% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.nodesplit_function.R
\name{prepare_nodesplit}
\alias{prepare_nodesplit}
\title{WinBUGS code for the node-splitting approach}
\usage{
prepare_nodesplit(measure, model, assumption)
}
\arguments{
\item{measure}{Character string indicating the effect measure with values
\code{"OR"}, \code{"MD"}, \code{"SMD"}, or \code{"ROM"} for the odds ratio,
mean difference, standardised mean difference and ratio of means,
respectively.}

\item{model}{Character string indicating the analysis model with values
\code{"RE"}, or \code{"FE"} for the random-effects and fixed-effect model,
respectively. The default argument is \code{"RE"}.}

\item{assumption}{Character string indicating the structure of the
informative missingness parameter. Set \code{assumption} equal to one of
the following: \code{"HIE-COMMON"}, \code{"HIE-TRIAL"}, \code{"HIE-ARM"},
\code{"IDE-COMMON"}, \code{"IDE-TRIAL"}, \code{"IDE-ARM"},
\code{"IND-CORR"}, or \code{"IND-UNCORR"}. The default argument is
\code{"IDE-ARM"}. The abbreviations \code{"IDE"}, \code{"HIE"}, and
\code{"IND"} stand for identical, hierarchical and independent,
respectively. \code{"CORR"} and \code{"UNCORR"} stand for correlated and
uncorrelated, respectively.}
}
\value{
An R character vector object to be passed to
  \code{\link{run_nodesplit}} through the
  \code{\link[base]{textConnection}} function as the argument \code{object}.
}
\description{
The WinBUGS code, as written by Dias et al., (2010) to run a
  one-stage Bayesian node-splitting model, extended to incorporate the
  pattern-mixture model for binary or continuous missing participant outcome
  data.
}
\details{
This functions creates the model in the JAGS dialect of the BUGS
  language. The output of this function constitutes the argument
  \code{model.file} of \code{\link[R2jags]{jags}} via the
  \code{\link[base]{textConnection}} function.

  The split nodes have been automatically selected via the
  \code{\link[gemtc]{mtc.nodesplit.comparisons}} function of the
  R-package \href{https://CRAN.R-project.org/package=gemtc}{gemtc}.
  See 'Details' in \code{\link{run_nodesplit}}.
}
\references{
Spineli LM, Kalyvas C, Papadimitropoulou K. Continuous(ly) missing outcome
data in network meta-analysis: a one-stage pattern-mixture model approach.
\emph{Stat Methods Med Res} 2021. \doi{10.1177/0962280220983544}

Spineli LM. An empirical comparison of Bayesian modelling strategies for
missing binary outcome data in network meta-analysis.
\emph{BMC Med Res Methodol} 2019;\bold{19}(1):86.
\doi{10.1186/s12874-019-0731-y}

Dias S, Welton NJ, Caldwell DM, Ades AE. Checking consistency in mixed
treatment comparison meta-analysis.
\emph{Stat Med} 2010;\bold{29}(7-8):932--44. \doi{10.1002/sim.3767}
}
\seealso{
\code{\link[R2jags]{jags}},
  \code{\link[gemtc]{mtc.nodesplit.comparisons}},
  \code{\link{run_nodesplit}}, \code{\link[base]{textConnection}},
}
\author{
{Loukia M. Spineli}
}
