% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npn_get_species.R
\name{npn_species}
\alias{npn_species}
\alias{npn_species_id}
\alias{npn_species_state}
\alias{npn_species_search}
\title{Get Species}
\usage{
npn_species(...)

npn_species_id(ids, ...)

npn_species_state(state, kingdom = NULL, ...)

npn_species_search(
  network = NULL,
  start_date = NULL,
  end_date = NULL,
  station_id = NULL,
  ...
)
}
\arguments{
\item{...}{Currently unused.}

\item{ids}{Integer vector of species ids for which to retrieve information.}

\item{state}{A US postal state code to filter results.}

\item{kingdom}{Filters results by taxonomic kingdom. Valid values include
\code{'Animalia'}, \code{'Plantae'}.}

\item{network}{filter species based on identifiers of NPN groups that are
actually observing data on the species. Takes a single numeric ID.}

\item{start_date}{filter species by date observed. This sets the start date
of the date range and must be used in conjunction with \code{end_date}.}

\item{end_date}{filter species by date observed. This sets the end date of
the date range and must be used in conjunction with \code{start_date}.}

\item{station_id}{filter species by a numeric vector of unique site
identifiers.}
}
\value{
A tibble with information on species in the NPN database and their
IDs.

A tibble with information on species in the NPN database and their
IDs, filtered by the species ID parameter.

A tibble with information on species in the NPN database whose
distribution includes a given state.

A tibble with information on species in the NPN database filtered by
partner group, dates and station/site IDs.
}
\description{
Returns a complete list of all species information of species represented in
the NPN database.

Returns information about a species based on the NPN's unique ID for that
species

Search for species by state

Search NPN species information using a number of different parameters, which
can be used in conjunction with one another, including:
\itemize{
\item Species on which a particular group or groups are actually collecting data
\item What species were observed in a given date range
\item What species were observed at a particular station or stations
}
}
\examples{
\dontrun{
npn_species()
}
\dontrun{
npn_species_id(ids = 3)
}
\dontrun{
npn_species_state(state = "AZ")
npn_species_state(state = "AZ", kingdom = "Plantae")
}
\dontrun{
species <- npn_species_search(
  start_date = "2013-01-01",
  end_date = "2013-05-15"
)
}
}
