% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fData.R
\name{sub-.mfData}
\alias{sub-.mfData}
\alias{[.mfData}
\title{Operator \code{sub-.mfData} to subset \code{mfData} obejcts}
\usage{
\method{[}{mfData}(mfD, i, j)
}
\arguments{
\item{mfD}{the multivariate functional dataset in form of \code{mfData} object.}

\item{i}{a valid expression to subset rows ( observations ) of the univariate
functional dataset.}

\item{j}{a valid expression to subset columns ( measurements over the grid )
of the univariate functional dataset (must be contiguous).}
}
\value{
The method returns and \code{mfData} object containing the
required subset ( both in terms  of observations and measurement points ) of
the multivariate functional dataset.
}
\description{
This method provides an easy and natural way to subset a multivariate
functional dataset stored in a \code{mfData} object, without having to
deal with the inner representation of \code{mfData} class.
}
\examples{
# Defining parameters
N = 1e2

P = 1e3

t0 = 0
t1 = 1

# Defining the measurement grid
grid = seq( t0, t1, length.out = P )

# Generating an exponential covariance matrix to be used in the simulation of
# the functional datasets (see the related help for details)
C = exp_cov_function( grid, alpha = 0.3, beta = 0.4 )

# Simulating the measurements of two univariate functional datasets with
# required center and covariance function
Data_1 = generate_gauss_fdata( N, centerline = sin( 2 * pi * grid ), Cov = C )
Data_2 = generate_gauss_fdata( N, centerline = sin( 2 * pi * grid ), Cov = C )

# Building the mfData object
mfD = mfData( grid, list( Data_1, Data_2 ) )

# Subsetting the first 10 elements and 10 time points
mfD[1:10, 1:10]

# Subsetting only observations
mfD[1:10,]

# Subsetting only time points (contiguously)
mfD[,1:10]

}
\seealso{
\code{\link{mfData}}
}
