% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cenLRinv.R
\name{cenLRinv}
\alias{cenLRinv}
\title{Inverse centred log-ratio transformation}
\usage{
cenLRinv(x, useClassInfo = TRUE)
}
\arguments{
\item{x}{an object of class \dQuote{clr}, \dQuote{data.frame} or
\dQuote{matrix}}

\item{useClassInfo}{if the object is of class \dQuote{clr}, the useClassInfo
is used to determine if the class information should be used. If yes, also
absolute values may be preserved.}
}
\value{
the transformed data set.
}
\description{
Applies the inverse centred log-ratio transformation.
}
\examples{

data(expenditures)
eclr <- cenLR(expenditures)
inveclr <- cenLRinv(eclr)
head(expenditures)
head(inveclr)
head(cenLRinv(eclr$x.clr))

}
\author{
Matthias Templ
}
\references{
Aitchison, J. (1986) \emph{The Statistical Analysis of
Compositional Data} Monographs on Statistics and Applied Probability.
Chapman \& Hall Ltd., London (UK). 416p.
}
\seealso{
\code{\link{cenLR}}, \code{\link{addLR}}, \code{\link{isomLR}},
\code{\link{addLRinv}}, \code{\link{isomLRinv}}
}
\keyword{manip}

