% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intTab.R
\name{intTab}
\alias{intTab}
\title{Interaction table}
\usage{
intTab(x, y, frequencies = c("relative", "absolute"))
}
\arguments{
\item{x}{an object of class table}

\item{y}{the corresponding independence table which is of class \dQuote{intTab}.}

\item{frequencies}{indicates whether absolute or relative frequencies should be computed.}
}
\value{
\itemize{
  \item{intTab}{The interaction table(s) with either relative or absolute frequencies.}
  \item{signs}{The sign illustrates if there is an excess of probability (plus), or a 
deficit (minus) regarding to the estimated probability table and the independece table in the clr space.}
}
}
\description{
Estimates the interaction table based on clr and inverse clr transformations.
}
\details{
Because of the compositional nature of probability tables, the independence tables should 
be estimated using geometric margins.
}
\examples{
data(precipitation)
tab1prob <- prop.table(precipitation)
tab1 <- indTab(precipitation)
intTab(tab1prob, tab1)
}
\references{
Juan Jose Egozcuea, Vera Pawlowsky-Glahn, Matthias Templ, Karel Hron (2015)
Independence in Contingency Tables Using Simplicial Geometry. 
\emph{Communications in Statistics - Theory and Methods}, Vol. 44 (18), 3978--3996.
DOI:10.1080/03610926.2013.824980
}
\author{
Matthias Templ
}
