% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outCoDa.R
\name{outCoDa}
\alias{outCoDa}
\alias{print.outCoDa}
\alias{plot.outCoDa}
\title{Outlier detection for compositional data}
\usage{
outCoDa(x, quantile = 0.975, method = "robust", h = 1/2, coda = TRUE)

\method{print}{outCoDa}(x, ...)

\method{plot}{outCoDa}(x, y, ..., which = 1)
}
\arguments{
\item{x}{compositional data}

\item{quantile}{quantile, corresponding to a significance level, is used as
a cut-off value for outlier identification: observations with larger
(squared) robust Mahalanobis distance are considered as potential outliers.}

\item{method}{either \dQuote{robust} (default) or \dQuote{standard}}

\item{h}{the size of the subsets for the robust covariance estimation
according the MCD-estimator for which the determinant is minimized (the
default is (n+p+1)/2).}

\item{coda}{if TRUE, data transformed to coordinate representation before outlier detection.}

\item{...}{additional parameters for print and plot method passed through}

\item{y}{unused second plot argument for the plot method}

\item{which}{1 ... MD against index
2 ... distance-distance plot}
}
\value{
\item{mahalDist }{resulting Mahalanobis distance} \item{limit
}{quantile of the Chi-squared distribution} \item{outlierIndex }{logical
vector indicating outliers and non-outliers} \item{method }{method used}
}
\description{
Outlier detection for compositional data using standard and robust
statistical methods.
}
\details{
The outlier detection procedure is based on (robust) Mahalanobis distances
in isometric logratio coordinates.  Observations with
squared Mahalanobis distance greater equal a certain quantile of the
chi-squared distribution are marked as outliers.

If method \dQuote{robust} is chosen, the outlier detection is based on the
homogeneous majority of the compositional data set. If method
\dQuote{standard} is used, standard measures of location and scatter are
applied during the outlier detection procedure.

plot method: the Mahalanobis distance are plotted against the index.
The dashed line indicates the (1 - alpha) quantile of the chi-squared
distribution. Observations with Mahalanobis distance greater than this
quantile could be considered as compositional outliers.
}
\note{
It is highly recommended to use the robust version of the procedure.
}
\examples{

data(expenditures)
oD <- outCoDa(expenditures)
oD
## providing a function:
oD <- outCoDa(expenditures, coda = log)

}
\references{
Egozcue J.J., Pawlowsky-Glahn, V., Mateu-Figueras, G.,
Barcelo-Vidal, C. (2003) Isometric logratio transformations for compositional
data analysis. \emph{Mathematical Geology}, 35 (3) 279-300. 

Filzmoser, P., and Hron, K. (2008) Outlier detection for compositional data
using robust methods. \emph{Math. Geosciences}, 40, 233-248.

Rousseeuw, P.J., Van Driessen, K. (1999) A fast algorithm for the minimum
covariance determinant estimator.  \emph{Technometrics}, 41, 212-223.
}
\seealso{
\code{\link{pivotCoord}}
}
\author{
Matthias Templ, Karel Hron
}
\keyword{multivariate}
