% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{confint.testMediation}
\alias{confint.bootTestMediation}
\alias{confint.sobelTestMediation}
\alias{confint.testMediation}
\title{Confidence intervals for (robust) mediation analysis}
\usage{
\method{confint}{bootTestMediation}(object, parm = NULL, level = NULL, ...)

\method{confint}{sobelTestMediation}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{"\link{testMediation}"}
containing results from (robust) mediation analysis, or an object inheriting
from class \code{"\link{fitMediation}"} containing a (robust) mediation
model fit.}

\item{parm}{an integer, character or logical vector specifying the
coefficients for which to extract or compute confidence intervals, or
\code{NULL} to extract or compute confidence intervals for all coefficients.}

\item{level}{for the \code{"bootTestMediation"} method, this is ignored and
the confidence level of the bootstrap confidence interval for the indirect
effect is used.  For the other methods, the confidence level of the
confidence intervals to be computed.  The default is to compute 95\%
confidence intervals.}

\item{\dots}{additional arguments are currently ignored.}
}
\value{
A numeric matrix containing the requested confidence intervals.
}
\description{
Extract or compute confidence intervals for coefficients from (robust)
mediation analysis.
}
\author{
Andreas Alfons
}
\seealso{
\code{\link{testMediation}}, \code{\link{fitMediation}},
\code{\link[=coef.testMediation]{coef}}
}
\keyword{utilities}

