% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{get.cluster.names}
\alias{get.cluster.names}
\alias{set.cluster.names}
\title{Get/Set Cluster Names by Marker Gene Expression}
\usage{
get.cluster.names(environment, types, min.fold = 1.25, max.Qval = 0.1,
  print = T)

set.cluster.names(environment, names)
}
\arguments{
\item{environment}{\code{environment} object}

\item{types}{data frame associating cell type or state with marker genes}

\item{min.fold}{minimum fold change to consider a marker as overexpressed}

\item{max.Qval}{maximum FDR q value to consider a marker as overexpressed}

\item{print}{whether to print output calculations}

\item{names}{cluster names defined in get.cluster.names}
}
\value{
\code{get.cluster.names} returns a vector containing assigned cluster
name labels

\code{set.cluster.names} returns an \code{environment} object coded
with cluster names
}
\description{
\code{get.cluster.names} uses predefined marker genes to assign clusters with
putative cell type or state labels.

\code{set.cluster.names} saves the cluster names in storage and in the \code{environment} object
}
\section{Functions}{
\itemize{
\item \code{set.cluster.names}: set annotations to clusters
}}

\examples{
\donttest{
LCMV1 <- setup_LCMV_example()
LCMV1 <- get.variable.genes(LCMV1, min.mean = 0.1, min.frac.cells = 0,
min.dispersion.scaled = 0.1)
LCMV1 <- PCA(LCMV1)
LCMV1 <- cluster.analysis(LCMV1)
types = rbind(
data.frame(type='Tfh',gene=c('Tcf7','Cxcr5','Bcl6')),
data.frame(type='Th1',gene=c('Cxcr6','Ifng','Tbx21')),
data.frame(type='Tcmp',gene=c('Ccr7','Bcl2','Tcf7')),
data.frame(type='Treg',gene=c('Foxp3','Il2ra')),
data.frame(type='Tmem',gene=c('Il7r','Ccr7')),
data.frame(type='CD8',gene=c('Cd8a')),
data.frame(type='CD4', gene = c("Cd4")),
data.frame(type='Cycle',gene=c('Mki67','Top2a','Birc5'))
)
summarize(LCMV1)
cluster_names <- get.cluster.names(LCMV1, types, min.fold = 1.0, max.Qval = 0.01)
LCMV1 <- set.cluster.names(LCMV1, names = cluster_names)
}
}
