% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/template_ci_heatmap_and_coded_fragments_to_pdf.R
\name{template_ci_heatmap_1_to_pdf}
\alias{template_ci_heatmap_1_to_pdf}
\title{Create a templated report for cognitive interviews}
\usage{
template_ci_heatmap_1_to_pdf(
  x,
  file,
  title = "Cognitive Interview: Heatmap and Coded Fragments",
  author = NULL,
  caption = "Heatmap",
  headingLevel = 1,
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{x}{The codebook object (as produced by a call to
\code{\link[=parse_sources]{parse_sources()}}).}

\item{file}{The filename to save the codebook to.}

\item{title}{The title to use.}

\item{author}{The author to specify in the PDF.}

\item{caption}{The caption for the heatmap.}

\item{headingLevel}{The level of the top-most headings.}

\item{silent}{Whether to be silent or chatty.}
}
\value{
x, invisibly
}
\description{
Use this function to export a templated report for cognitive interviews.
To embed it in an R Markdown file, use
!!! CREATE rock::knit_codebook() !!!
}
\examples{
\donttest{
### Use a temporary file to write to
tmpFile <- tempfile(fileext = ".pdf");

### Load an example CI
examplePath <- file.path(system.file(package="rock"), 'extdata');
parsedCI <- parse_source(file.path(examplePath,
                                   "ci_example_1.rock"));

rock::template_ci_heatmap_1_to_pdf(
  parsedCI,
  file = tmpFile
);
}
}
