% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_fullyMergedCodeTrees.R
\name{show_fullyMergedCodeTrees}
\alias{show_fullyMergedCodeTrees}
\title{Show the fully merged code tree(s)}
\usage{
show_fullyMergedCodeTrees(x)
}
\arguments{
\item{x}{A parsed source(s) object.}
}
\value{
The result of a call to \code{\link[DiagrammeR:render_graph]{DiagrammeR::render_graph()}}.
}
\description{
Show the fully merged code tree(s)
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "example-1.rock");

### Load example source
loadedExample <- rock::parse_source(exampleFile);

### Show merged code tree
show_fullyMergedCodeTrees(loadedExample);
}
