% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prereg_initialize.R
\name{prereg_initialize}
\alias{prereg_initialize}
\title{Initialize a (pre)registration}
\usage{
prereg_initialize(x, initialText = "Unspecified")
}
\arguments{
\item{x}{The (pre)registration form specification, as a URL to a Google
Sheet or online file or as the path to a locally stored file.}

\item{initialText}{The text to initialize every field with.}
}
\value{
The empty (pre)registration specification.
}
\description{
To initialize a (pre)registration, pass the URL to a Google Sheet holding
the (pre)registration form specification (in \{preregr\} format), see the
"\href{https://r-packages.gitlab.io/preregr/articles/creating_form_from_spreadsheet.html}{Creating a form from a spreadsheet}"
vignette), the path to a file with a spreadsheet holding such a
specification, or a loaded or imported \{preregr\} (pre)registration form.
}
\details{
For an introduction to working with \{preregr\} (pre)registrations,
see the
"\href{https://r-packages.gitlab.io/preregr/articles/specifying_prereg_content.html}{Specifying preregistration content}"
vignette.
}
\examples{
rock::prereg_initialize(
  "preregQE_v0_95"
);
}
