\name{cutBySD}
\alias{cutBySD}
\title{Returns center values of x, the mean, mean-std.dev, mean+std.dev}
\usage{
  cutBySD(x, n = 3)
}
\arguments{
  \item{x}{A numeric variable}

  \item{n}{Should be an odd number 1, 3, 5, or 7. If 2 < n
  < 5, values that divide the data at c(m-sd, m, m+sd) are
  returned. If n > 4, the returned values are c(m-2sd,
  m-sd, m, m+sd, m+2sd).}
}
\value{
  A named vector
}
\description{
  If the numeric variable has fewer than 6 unique observed
  values, this will send the data to cutByTable.
}
\examples{
x <- rnorm(100, m = 100, s = 20)
cutBySD (x, n = 3)
cutBySD (x, n = 5)
}
\author{
  Paul E. Johnson <pauljohn@ku.edu>
}

