% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_emails.R
\name{extract_emails}
\alias{extract_emails}
\title{Extract emails contents}
\usage{
extract_emails(release, save.dir = getwd(), extractor, ...)
}
\arguments{
\item{release}{Name of the batch of release of emails; see details.}

\item{save.dir}{Directory where to save the extracted text defaults to
\code{getwd()}}

\item{extractor}{Full path to pdf extractor \code{pdftotext}, see details.}

\item{...}{additional parameters to pass to \code{pdftotext}.}
}
\description{
Extract content of manually downloaded emails.
}
\examples{
\dontrun{
# download emails
download_emails("August") # August release

dir.create("emails_pdf") # dir to extract zip

unzip("August.zip", exdir = "./emails_pdf")

# create directory to store extracted contents
dir.create("emails_txt")

ext <- get_xpdf()

extarct_contents(emails = "HRC_Email_296", dest = "./emails_txt", extractor = ext)
}

}
\seealso{
\code{\link{get_xpdf}}, \code{\link{download_emails}}
}
\author{
John Coene \email{jcoenep@gmail.com}
}
