% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mrs_age_schema}
\alias{mrs_age_schema}
\title{Star schema for Mortality Reporting System by Age}
\format{
A \code{star_schema} object.
}
\usage{
mrs_age_schema
}
\description{
Definition of schemas for facts and dimensions for the Mortality Reporting System
considering the age classification.
}
\details{
Dimension schemes can be defined using variables so that you do not have to repeat
the definition in several multidimensional designs.
}
\examples{
# Defined by:

when <- dimension_schema(name = "When",
                         attributes = c("Year"))
where <- dimension_schema(name = "Where",
                          attributes = c("REGION",
                                         "State",
                                         "City"))
mrs_age_schema <- star_schema() |>
  define_facts(name = "MRS Age",
               measures = c("All Deaths")) |>
  define_dimension(when) |>
  define_dimension(where) |>
  define_dimension(name = "Who",
                   attributes = c("Age"))

}
\seealso{
\code{\link{ft_age}}

Other mrs example schema: 
\code{\link{mrs_cause_schema}}
}
\concept{mrs example schema}
\keyword{datasets}
