% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_database.R
\name{star_database}
\alias{star_database}
\title{\code{star_database} S3 class}
\usage{
star_database(schema, instances, unknown_value = NULL)
}
\arguments{
\item{schema}{A \code{star_schema} object.}

\item{instances}{A flat table to define the database instances according to the schema.}

\item{unknown_value}{A string, value used to replace NA values in dimensions.}
}
\value{
A \code{star_database} object.
}
\description{
A \code{star_database} object is created from a \code{star_schema} object and a flat
table that contains the data from which database instances are derived.
}
\details{
Measures and attributes of the \code{star_schema} must correspond to the names of
the columns of the flat table.

Since NA values cause problems when doing Join operations between tables,
you can indicate the value that will be used to replace them before doing
these operations. If none is indicated, a default value is taken.
}
\examples{

db <- star_database(mrs_cause_schema, ft_num)

}
\seealso{
\code{\link{as_tibble_list}}, \code{\link{as_dm_class}}, \code{\link{star_schema}}

Other star database and constellation definition functions: 
\code{\link{constellation}()},
\code{\link{snake_case}()}
}
\concept{star database and constellation definition functions}
