% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constellation.R, R/generic.R, R/star_database.R
\name{as_dm_class.constellation}
\alias{as_dm_class.constellation}
\alias{as_dm_class}
\alias{as_dm_class.star_database}
\title{Generate a \code{dm} class with fact and dimension tables}
\usage{
\method{as_dm_class}{constellation}(db, pk_facts = TRUE)

as_dm_class(db, pk_facts)

\method{as_dm_class}{star_database}(db, pk_facts = TRUE)
}
\arguments{
\item{db}{A \code{star_database} or \code{constellation} object.}

\item{pk_facts}{A boolean, include primary key in fact tables.}
}
\value{
A \code{dm} object.
}
\description{
To port databases to other work environments it is useful to be able to
export them as a \code{dm} class, as this function does, in this way it can be
saved directly in a DBMS.
}
\examples{

db1 <- star_database(mrs_cause_schema, ft_num) |>
  snake_case()
dm1 <- db1 |>
  as_dm_class()

db2 <- star_database(mrs_age_schema, ft_age) |>
  snake_case()

ct <- constellation("MRS", list(db1, db2))
dm <- ct |>
  as_dm_class()

}
\seealso{
\code{\link{star_database}}, \code{\link{constellation}}

Other star database and constellation exportation functions: 
\code{\link{as_tibble_list.constellation}()}
}
\concept{star database and constellation exportation functions}
