% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_database.R
\name{get_fact_measure_names}
\alias{get_fact_measure_names}
\alias{get_fact_measure_names.star_database}
\title{Get the names of the measures of a star database}
\usage{
get_fact_measure_names(db)

\method{get_fact_measure_names}{star_database}(db)
}
\arguments{
\item{db}{A \code{star_database} object.}
}
\value{
A vector of strings, measure names.
}
\description{
Obtain the names of the measures of a star database.
}
\examples{

names <- star_database(mrs_cause_schema, ft_num) |>
  get_fact_measure_names()

}
\seealso{
\code{\link{as_tibble_list}}, \code{\link{as_dm_class}}

Other star database and constellation definition functions: 
\code{\link{constellation}()},
\code{\link{get_dimension_attribute_names}()},
\code{\link{get_role_playing_dimension_names}()},
\code{\link{role_playing_dimension}()},
\code{\link{set_dimension_attribute_names}()},
\code{\link{set_fact_measure_names}()},
\code{\link{snake_case}()},
\code{\link{star_database}()}
}
\concept{star database and constellation definition functions}
