% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table_transform.R
\name{transform_to_attribute}
\alias{transform_to_attribute}
\alias{transform_to_attribute.flat_table}
\title{Transform to attribute}
\usage{
transform_to_attribute(ft, measures, width, decimal_places, k_sep, decimal_sep)

\method{transform_to_attribute}{flat_table}(
  ft,
  measures,
  width = 1,
  decimal_places = 0,
  k_sep = ",",
  decimal_sep = "."
)
}
\arguments{
\item{ft}{A \code{flat_table} object.}

\item{measures}{A vector of strings, measure names.}

\item{width}{An integer, string length.}

\item{decimal_places}{An integer, number of decimal places.}

\item{k_sep}{A character, indicates thousands separator.}

\item{decimal_sep}{A character, indicates decimal separator.}
}
\value{
ft A \code{flat_table} object.
}
\description{
Transform measures into attributes. We can indicate if we want all the numbers
in the result to have the same length and the number of decimal places.
}
\details{
If a number > 1 is specified in the \code{width} parameter, at least that length
will be obtained in the result, padded with blanks on the left.
}
\examples{

ft <- flat_table('iris', iris) |>
  transform_to_attribute(
    measures = "Sepal.Length",
    width = 3,
    decimal_places = 2
  )

}
\seealso{
\code{\link{flat_table}}

Other flat table transformation functions: 
\code{\link{add_custom_column}()},
\code{\link{remove_instances_without_measures}()},
\code{\link{replace_empty_values}()},
\code{\link{replace_string}()},
\code{\link{replace_unknown_values}()},
\code{\link{select_attributes}()},
\code{\link{select_instances_by_comparison}()},
\code{\link{select_instances}()},
\code{\link{select_measures}()},
\code{\link{separate_measures}()},
\code{\link{transform_attribute_format}()},
\code{\link{transform_from_values}()},
\code{\link{transform_to_measure}()},
\code{\link{transform_to_values}()}
}
\concept{flat table transformation functions}
