% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolayer.R
\name{as_geolayer}
\alias{as_geolayer}
\alias{as_geolayer.star_database}
\title{Get a \code{geolayer} object}
\usage{
as_geolayer(db, dimension, attribute, geometry, include_nrow_agg)

\method{as_geolayer}{star_database}(
  db,
  dimension = NULL,
  attribute = NULL,
  geometry = NULL,
  include_nrow_agg = FALSE
)
}
\arguments{
\item{db}{An \code{star_database} object.}

\item{dimension}{A string, dimension name.}

\item{attribute}{A vector, attribute names.}

\item{geometry}{A string, geometry name.}

\item{include_nrow_agg}{A boolean, include default measure.}
}
\value{
A \code{geolayer} object.
}
\description{
From a \code{star_database} with at least one geoattribute, we obtain a \code{geolayer}
object that allows us to select the data to obtain a vector layer with
geographic information.
}
\details{
If only one geographic attribute is defined, it is not necessary to indicate
the dimension or the attribute. By default, polygon geometry is considered.
}
\examples{

gl_polygon <- mrs_db_geo |>
  as_geolayer()

gl_point <- mrs_db_geo |>
  as_geolayer(geometry = "point")

}
\seealso{
Other query functions: 
\code{\link{as_GeoPackage}()},
\code{\link{filter_dimension}()},
\code{\link{get_layer}()},
\code{\link{get_variable_description}()},
\code{\link{get_variables}()},
\code{\link{run_query}()},
\code{\link{select_dimension}()},
\code{\link{select_fact}()},
\code{\link{set_layer}()},
\code{\link{set_variables}()},
\code{\link{star_query}()}
}
\concept{query functions}
