% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoattribute.R
\name{define_geoattribute}
\alias{define_geoattribute}
\alias{define_geoattribute.star_database}
\title{Define \code{geoattribute} of a dimension}
\usage{
define_geoattribute(db, dimension, attribute, from_layer, by, from_attribute)

\method{define_geoattribute}{star_database}(
  db,
  dimension = NULL,
  attribute = NULL,
  from_layer = NULL,
  by = NULL,
  from_attribute = NULL
)
}
\arguments{
\item{db}{A \code{star_database} object.}

\item{dimension}{A string, dimension name.}

\item{attribute}{A vector, attribute names.}

\item{from_layer}{A \code{sf} object.}

\item{by}{a vector of correspondence of attributes of the dimension with the
\code{sf} layer structure.}

\item{from_attribute}{A vector, attribute names.}
}
\value{
A \code{star_database} object.
}
\description{
Define a set of attributes as a dimension's \code{geoattribute}. The set of attribute
values must uniquely designate the instances of the given geographic layer.
}
\details{
The definition can be done in two ways: Associates the instances of the attributes
with the instances of a geographic layer or defines it from the geometry of
previously defined geographic attributes.

Multiple attributes can be specified in the \code{attribute} parameter, the geographical
attribute is the combination of all of them.

If defined from a layer (\code{from_layer} parameter), additionally the attributes
used for the join between the tables (dimension and layer tables) must be
indicated (\code{by} parameter).

If defined from another attribute, it should have the same or finer granularity,
to obtain the result by grouping its instances. The considered attribute can be
the pair that defines longitude and latitude.

If other geographic information has previously been associated with that attribute,
the new information is considered and previous instances for which no new information
is provided are also added.

If the geometry provided is polygons, a point layer is also generated.
}
\examples{

db <- mrs_db |>
  define_geoattribute(
    dimension = "where",
    attribute = "state",
    from_layer = us_layer_state,
    by = "STUSPS"
  ) |>
  define_geoattribute(
    dimension = "where",
    attribute = "region",
    from_attribute = "state"
  )  |>
  define_geoattribute(
    dimension = "where",
    attribute = "city",
    from_attribute = c("long", "lat")
  )

}
\seealso{
Other star database geographic attributes: 
\code{\link{check_geoattribute_geometry}()},
\code{\link{get_geoattribute_geometries}()},
\code{\link{get_geoattributes}()},
\code{\link{get_layer_geometry}()},
\code{\link{get_point_geometry}()},
\code{\link{summarize_layer}()}
}
\concept{star database geographic attributes}
