% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoattribute.R
\name{get_geoattribute_geometries}
\alias{get_geoattribute_geometries}
\alias{get_geoattribute_geometries.star_database}
\title{Get geoattribute geometries}
\usage{
get_geoattribute_geometries(db, dimension, attribute)

\method{get_geoattribute_geometries}{star_database}(db, dimension = NULL, attribute = NULL)
}
\arguments{
\item{db}{A \code{star_database} object.}

\item{dimension}{A string, dimension name.}

\item{attribute}{A vector, attribute names.}
}
\value{
A vector of strings.
}
\description{
For each geoattribute, get its geometries.
}
\details{
If the name of the dimension is not indicated, it is considered the first one
that has geoattributes defined.
}
\examples{

db <- mrs_db |>
  define_geoattribute(
    dimension = "where",
    attribute = "state",
    from_layer = us_layer_state,
    by = "STUSPS"
  )

geometries <- db |>
  get_geoattribute_geometries(
    dimension = "where",
    attribute = "state"
  )

}
\seealso{
Other star database geographic attributes: 
\code{\link{check_geoattribute_geometry}()},
\code{\link{define_geoattribute}()},
\code{\link{get_geoattributes}()},
\code{\link{get_layer_geometry}()},
\code{\link{get_point_geometry}()},
\code{\link{summarize_layer}()}
}
\concept{star database geographic attributes}
