% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolayer.R
\name{set_layer}
\alias{set_layer}
\alias{set_layer.geolayer}
\title{Set geographic layer}
\usage{
set_layer(gl, layer)

\method{set_layer}{geolayer}(gl, layer)
}
\arguments{
\item{gl}{A \code{geolayer} object.}

\item{layer}{A \code{sf} object.}
}
\value{
A \code{geolayer} object.
}
\description{
If for some reason we modify the geographic layer, for example, to add a new
calculated variable, we can set that layer to become the new geographic layer
of the \code{geolayer} object using this function.
}
\examples{

gl <- mrs_db_geo |>
  as_geolayer()

l <- gl |>
  get_layer()

l$tpc_001 <- l$var_002 * 100 / l$var_001

gl <- gl |>
  set_layer(l)

}
\seealso{
Other query functions: 
\code{\link{as_GeoPackage}()},
\code{\link{as_geolayer}()},
\code{\link{filter_dimension}()},
\code{\link{get_layer}()},
\code{\link{get_variable_description}()},
\code{\link{get_variables}()},
\code{\link{run_query}()},
\code{\link{select_dimension}()},
\code{\link{select_fact}()},
\code{\link{set_variables}()},
\code{\link{star_query}()}
}
\concept{query functions}
