% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollmatch.R
\name{rollmatch}
\alias{rollmatch}
\title{Rolling entry matching}
\usage{
rollmatch(formula, data, tm, entry, id, lookback = 1, caliper = 0,
  weighted_pooled_stdev = FALSE, num_matches = 3, match_on = "logit",
  model_type = "logistic", replacement = TRUE)
}
\arguments{
\item{formula}{A \code{\link[stats]{formula}} in the form
\code{treat ~ x1 + x2 ...} where \code{treat} is a binary treatment
indicator (Treat = 1, Control = 0) and \code{x1} and \code{x2} are
pre-treatment covariates. Both the treatment indicator and
pre-treatment covariates must be contained in the input dataset.}

\item{data}{The input panel dataset.}

\item{tm}{The time period indicator.}

\item{entry}{The time period in which the participant enrolled in the
intervention (in the same units as the tm variable).}

\item{id}{The individual id variable.}

\item{lookback}{The number of time periods to look back before the
time period of enrollment (1-10).}

\item{caliper}{The pre-specified distance within which to allow matching.
The caliper width is calculated as the \code{caliper} multiplied by the
pooled standard deviation of the propensity scores or the logit of the
propensity scores - depending on the value of \code{match_on}.}

\item{weighted_pooled_stdev}{Option that allows for weighted pooled standard
deviation for caliper matching. FALSE for average pooled standard
deviation and TRUE for weighted pooled standard deviation.}

\item{num_matches}{The number of comparison beneficiary matches to attempt
to assign to each treatment beneficiary}

\item{match_on}{Match on estimated propensity score ("pscore") or logit of
estimated propensity score ("logit").}

\item{model_type}{Use logistic regression ("logistic") or "probit"
regression ("probit") to estimate the predicted probability of participating
in the innovation.}

\item{replacement}{Assign comparison beneficiaries with replacement (TRUE)
or without replacement (FALSE). If \code{replacement} is TRUE, then
comparison beneficiaries will be allowed to be used with replacement within
a single quarter, but will be allowed to match to different treatment
beneficiaries across multiple quarters.}
}
\value{
\code{rollmatch} returns an object of class "rollmatch".

An object of class "rollmatch" is a list containing the following components:
\item{call}{The original \code{rollmatch} call.}
\item{model}{The output of the model used to estimate the distance measure.}
\item{scores}{The propensity score and logit of the propensity score. }
\item{data}{The original dataset with matches, scores, and weights applied.}
\item{summary}{A basic summary table.}
\item{balance}{The balancing table.}
}
\description{
\code{rollmatch} is the main function of the package
\emph{<rollmatch>}, which implements a comparison group selection
methodology for interventions with rolling participant entry over time.
A difficulty in evaluating rolling entry interventions is that a suitable
"entry" date is not observed for non-participants. This method, called
rolling entry matching, assigns potential comparison non-participants
multiple counterfactual entry periods which allows for matching of
participant and non-participants based on data immediately preceding each
participant's specific entry period, rather than using data from a fixed
pre-intervention period.
}
\details{
Rolling entry matching requires three steps. First, a quasi-panel dataset
is constructed containing multiple observations of non-participants (one for
each entry period). Participants enter the data once in the baseline period
immediately preceding their unique entry into the intervention. Time-varying
covariates (e.g., health conditions, spending, utilization) are dynamic for
each entry period's non-participant observations.  Second, a predicted
probability of treatment is obtained for participants and non-participants
(e.g., through propensity score matching).  Finally, the pool of potential
comparisons for each participant is restricted to those that have the same
"entry period" into the intervention. The matching algorithm then selects
the best matched comparison(s) for each participant from the pool of
non-participants with the same entry period.
}
\examples{
data(package="rollmatch", "rem_synthdata_small")

formula <- as.formula(treat ~ qtr_pmt + yr_pmt + age)

r_match <- rollmatch(formula, data = rem_synthdata_small, tm = "quarter",
                       entry = "entry_q", id = "indiv_id", caliper = 0.2)

r_match

}
