% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_heatmap.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Plot Heatmap}
\usage{
plot_heatmap(
  tomic,
  feature_var = NULL,
  sample_var = NULL,
  value_var = NULL,
  cluster_dim = "both",
  distance_measure = "dist",
  hclust_method = "ward.D2",
  change_threshold = Inf,
  plot_type = "grob",
  max_display_features = 800
)
}
\arguments{
\item{tomic}{Either a \code{tidy_omic} or \code{triple_omic} object}

\item{feature_var}{variable from "features" to use as a unique feature
label.}

\item{sample_var}{variable from "samples" to use as a unique sample label.}

\item{value_var}{which variable in "measurements" to use for quantification.}

\item{cluster_dim}{rows, columns, or both}

\item{distance_measure}{variable to use for computing dis-similarity
\describe{
  \item{corr}{pearson correlation}
  \item{dist}{euclidean distance}
}}

\item{hclust_method}{method from stats::hclust to use for clustering}

\item{change_threshold}{values with a more extreme absolute change will be
thresholded to this value.}

\item{plot_type}{plotly (for interactivity) or grob (for a static ggplot)}

\item{max_display_features}{aggregate and downsample distinct feature to
this number to speed to up heatmap rendering.}
}
\value{
a ggplot2 grob
}
\description{
Generate a heatmap visualization of a features x samples matrix of
  measurements.
}
\examples{

library(dplyr)

tomic <- brauer_2008_triple \%>\%
  filter_tomic(
    filter_type = "category",
    filter_table = "features",
    filter_variable = "BP",
    filter_value = c(
      "protein biosynthesis",
      "rRNA processing", "response to stress"
    )
  )

plot_heatmap(
  tomic = tomic,
  value_var = "expression",
  change_threshold = 5,
  cluster_dim = "rows",
  plot_type = "grob",
  distance_measure = "corr"
)
}
