% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ropenblas.R
\name{rcompiler}
\alias{rcompiler}
\title{Compile a version of \R on GNU/Linux systems}
\usage{
rcompiler(x = NULL, with_blas = NULL, complementary_flags = NULL)
}
\arguments{
\item{x}{Version of \R you want to compile. By default (\code{x = NULL}) will be compiled the latest stable version of the \R
language. For example, \code{x = "3.6.2"} will compile and link \strong{R-3.6.2} version  as the major version on your system.}

\item{with_blas}{String, \code{--with-blas = NULL} by default, with flags for \code{--with-blas} used in the \R compilation process.
Details on the use of this flag can be found \href{https://cran.r-project.org/doc/manuals/r-devel/R-admin.html}{\strong{here}}.}

\item{complementary_flags}{String, \code{complementary_flags = NULL} by default, for adding complementary flags in the \href{https://www.r-project.org/}{\strong{R}} language
compilation process.}
}
\value{
Returns a warning message informing you if the procedure occurred correctly. You will also be able to receive information about
missing dependencies.
}
\description{
This function is responsible for compiling a version of the \R language.
}
\details{
This function is responsible for compiling a version of the \href{https://www.r-project.org/}{\strong{R}} language. The \code{x} argument is the version of \href{https://www.r-project.org/}{\strong{R}} that you want to compile.
For example, \code{x = "4.0.0"} will compile and link \strong{R-4.0.0} version  as the major version on your system. By default (\code{x = NULL}) will be compiled the latest stable version of the \href{https://www.r-project.org/}{\strong{R}}.

For example, to compile the latest stable version of the \href{https://www.r-project.org/}{\strong{R}} language, do:\preformatted{ rcompiler()
}

Regardless of your GNU/Linux distribution and what version of \href{https://www.r-project.org/}{\strong{R}} is in your repositories, you can have the latest stable version of the \href{https://www.r-project.org/}{\strong{R}} language compiled
into your computer architecture.

You can use the \code{rcompiler()} function to compile different versions of \href{https://www.r-project.org/}{\strong{R}}. For example, running \code{rcompiler(x = "3.6.3")} and \code{rcompiler()} will install versions 3.6.3 and 4.0.0 on its GNU/Linux distribution,
respectively. If you are in version 4.0.0 of \href{https://www.r-project.org/}{\strong{R}} and run the code \code{rcompiler(x = "3.6.3")} again, the function will identify the existence of version 3.6.3 in the system and give you the option to use the binaries
that were built in a previous compilation. This avoids unnecessarys compilations.

In addition to the \code{x} argument, the\code{ rcompiler()} function has two other arguments that will allow you to change and pass new compilation flags. Are they:
\enumerate{
\item \code{with_blas}: This argument sets the \code{--with-blas} flag in the R language compilation process and must be passed as a string. Details on the use of this flag
can be found \href{https://cran.r-project.org/doc/manuals/r-devel/R-admin.html}{\strong{here}}. If \code{with_blas = NULL} (default), then it will be considered:\preformatted{./configure --prefix=/opt/R/version_r --enable-memory-profiling --enable-R-shlib
 --enable-threads=posix --with-blas="-L/opt/OpenBLAS/lib -I/opt/OpenBLAS/include
 -lpthread -lm"
}

Most likely, you will have little reason to change this aprgument. Unless you know what you're doing, consider \code{with_blas = NULL}. Do not change the installation directory,
that is, always consider \verb{--prefix = /opt/R/version_r}, where\code{ version_r} is a valid version of \href{https://www.r-project.org/}{\strong{R}}. For a list of valid versions of
\href{https://www.r-project.org/}{\strong{R}}, run the \code{last_version_r()}. Installing \href{https://www.r-project.org/}{\strong{R}} in the \verb{/opt/R/version_r} directory is important because some
functions in the package require this. Both the \href{https://www.r-project.org/}{\strong{R}} language and the \href{https://www.openblas.net/}{\strong{OpenBLAS}} library will be installed in the \verb{/opt} directory.
If this directory does not exist in your GNU/Linux distribution, it will be created;
\item \code{complementary_flags}: String (\code{complementary_flags = NULL} by default) for adding complementary flags in the \href{https://www.r-project.org/}{\strong{R}} language compilation process.
Passing a string to \code{complementary_flags} will compile it in the form:\preformatted{./configure --with-blas="..." complementary_flags
}
}
}
\examples{
# rcompiler()
}
\seealso{
\code{\link{ropenblas}}, \code{\link{last_version_r}}
}
