% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/inconsistencies.R
\name{findInconsistencies}
\alias{findInconsistencies}
\title{Find inconsistencies in preference information}
\usage{
findInconsistencies(problem)
}
\arguments{
\item{problem}{Problem to investigate.}
}
\value{
List of ordered by cardinality sets of indices of preference
information that makes problem inconsistent. Use \code{\link{getRestrictions}}
on sets to find out related preference information.
}
\description{
This function finds sets of pieces of preference information that make
problem inconsistent.
}
\examples{
perf <- matrix(c(1, 2, 2, 1), ncol = 2)
problem <- buildProblem(perf, 3, TRUE, c('g', 'g'), c(0, 0))
problem <- addAssignmentsUB(problem, c(1, 1))
problem <- addAssignmentsLB(problem, c(2, 2))

checkConsistency(problem) # TRUE

problem <- addAssignmentsLB(problem, c(1, 3)) # added inconsistency

checkConsistency(problem) # FALSE

inconsistencies <- findInconsistencies(problem)

setsOfprefInfo <- lapply(inconsistencies,
                         function(x) { getRestrictions(problem, x) })
}

