% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gol.R
\name{gol_node_info}
\alias{gol_node_info}
\alias{ott_id.gol_node}
\alias{synth_sources}
\alias{synth_sources.gol_node}
\alias{tax_rank.gol_node}
\title{Node info}
\usage{
gol_node_info(ott_id = NULL, include_lineage = FALSE, ...)

\method{tax_rank}{gol_node}(tax)

\method{ott_id}{gol_node}(tax, ...)

synth_sources(tax)

\method{synth_sources}{gol_node}(tax)
}
\arguments{
\item{ott_id}{The OpenTree taxonomic identifier.}

\item{include_lineage}{Boolean. Whether to return the lineage of
the node from the synthetic tree. Optional; default = FALSE.}

\item{...}{additional arguments to customize the API call (see
?rotl for more information)}

\item{tax}{an object returned by \code{gol_node_info}.}
}
\value{
\code{gol_node_info} returns a list of summary information
    about the queried node.

\itemize{

    \item {tree_id} {The tree identifier for a given study.}

    \item {num_synth_tips} {Numeric. The number of synthetic
           tree tip descendants.}

    \item {name} {String. The taxonomic name of the queried node
       (if it is a named node).}

    \item {rank} {String. The taxonomic rank of the queried node
    (if it is a named node).}

   \item {ott_id} {Numeric. The OpenTree Taxonomy ID (ottID) of
    the queried node (if it is a named node).}

   \item {num_tips} {Numeric. The number of taxonomic tip
    descendants.}

    \item {tree_sources} {A list of supporting source
    trees in the graph. May differ from \code{"synth_sources"}, if
    trees are in the graph, but were not used in constructing the
    synthetic tree. Each source has:}

    \itemize{

        \item {study_id} {The study identifier. Will typically include
        a prefix ("pg_" or "ot_").}

        \item {tree_id} {The tree identifier for a given study.}

        \item {git_sha} {The git SHA identifying a particular source
    version.}

    }

	\item {tax_source} {String. Source taxonomy IDs (if it is a
    named node), e.g. "ncbi:9242,gbif:5289,irmng:104628".}

   \item {synth_sources} {A list of supporting synthesis source
    trees, each with:}

       \itemize{

          \item {git_sha} {The git SHA identifying a particular source
           version.}

          \item {tree_id} {The tree id associated with the study id used.}

         \item {study_id} {The study identifier. Will typically include
         a prefix ("pg_" or "ot_").}


       }

   \item {node_id} { The identifier for the node used by the neo4j
      database. These identifiers are not persistent and shouldn't be
      used.}

  \item {in_synth_tree} {Boolean. Whether the \code{ott_id} is
      included in the synthetic tree.}


}

    \code{tax_rank} and \code{ott_id} return vectors (character,
    and numeric respectively).
}
\description{
Get summary information about a node in the graph database
}
\details{
Summary information about a queried node, including 1)
    whether it is in the graph database, 2) whether it is in the
    synthetic tree, 3) supporting study sources, 4) number of
    descendant tip taxa, 5) graph node ID, and 6) taxonomic
    information (if it is a named node in the graph), including:
    name, rank, OpenTree Taxonomy ID (ottID), and source taxonomy
    IDs.
}
\examples{
\dontrun{
birds <- gol_node_info(ott_id=81461)
synth_sources(birds)
tax_rank(birds)
ott_id(birds)
}
}

