% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return_roclet.R
\name{return_roclet}
\alias{return_roclet}
\title{Roclet: check presence of \verb{@return} in documentation for exported functions}
\usage{
return_roclet()
}
\value{
A roclet to be used e.g. with \code{\link[roxygen2:roxygenise]{roxygen2::roxygenise()}}
}
\description{
This roclet checks presence of \verb{@return} that
generates \verb{\\value} in \code{Rd} files.

Generally you will not call this function directly
but will instead use \code{\link[roxygen2:roxygenise]{roxygen2::roxygenise()}} specifying this roclet.
}
\examples{
x <- "#' Summing two numbers\n#'\n#' @export\nf <- function(x, y) {\n   x + y\n}\n"
cat(x)
roxygen2::roc_proc_text(return_roclet(), x)

}
\seealso{
Other roclets:
\code{\link{testthat_roclet}},
\code{\link{tinytest_roclet}},
\code{\link{param_roclet}},
\code{\link{examples_roclet}},
\code{\link[roxygen2]{namespace_roclet}},
\code{\link[roxygen2]{rd_roclet}},
\code{\link[roxygen2]{vignette_roclet}}.

Other roclets: 
\code{\link{examples_roclet}()},
\code{\link{param_roclet}()},
\code{\link{testthat_roclet}()},
\code{\link{tinytest_roclet}()}
}
\concept{roclets}
