#sccs @(#)text.rpart.s	1.7 02/18/97
# This is a modification of text.tree.  
# Fancy option has been added in (to mimic post.tree)
#

text.rpart <-  function(x, splits = T, label = "yval", FUN = text, all=F,
		        pretty = NULL, digits = .Options$digits - 3, 
                        use.n=F, fancy=F, fwidth=.8, fheight =.8, ...)
{
  FUN1 <- function(x, y, lab,...){
    ind <- lab != "NA"
    FUN(x[ind], y[ind], lab[ind], ...)
  }
	if(!inherits(x, "rpart")) stop("Not legitimate rpart")
	frame <- x$frame
	col <- names(frame)
	method <- x$method
	ylevels <- attr(x,'ylevels')
	if(!is.null(ylevels <- attr(x, "ylevels")))
		col <- c(col, ylevels)
	if(is.na(match(label, col)))
		stop("Label must be a column label of the frame component of the tree"
			)
        charw <- diff(par("usr")[1:2])/ par("pin")[1]
        charht <- diff(par("usr")[3:4])/ par("pin")[2]
        if(!is.null(srt <- list(...)$srt) && srt == 90){
          cxy <- c(charw*par("cin")[2], charht*par("cin")[1])
        } else {
          cxy <- c(charw*par("cin")[1], charht*par("cin")[2])
        }
	xy <- rpartco(x)

        node <- as.numeric(row.names(x$frame))
        is.left <- (node%%2 ==0)        #left hand sons
        node.left <- node[is.left]
	parent <- match(node.left/2, node)

#Put left splits at the parent node

	if(splits) {
		left.child <- match(2 * node, node)
		right.child <- match(node * 2 + 1, node)
		rows <- labels(x, pretty = pretty)

		if(fancy) {
		  ## put split labels on branches instead of nodes

		  xytmp <- rpart.branch(x=xy$x,y=xy$y,node=node)
		  leftptx <- (xytmp$x[2,]+xytmp$x[1,])/2
		  leftpty <- (xytmp$y[2,]+xytmp$y[1,])/2
		  rightptx <- (xytmp$x[3,]+xytmp$x[4,])/2
		  rightpty <- (xytmp$y[3,]+xytmp$y[4,])/2

		  FUN1(leftptx,leftpty+.52*cxy[2],
		      rows[left.child[!is.na(left.child)]])
		  FUN1(rightptx,rightpty-.52*cxy[2],
		      rows[right.child[!is.na(right.child)]])
		}

		else FUN1(xy$x, xy$y + 0.5 * cxy[2], rows[left.child], ...)
	}
	leaves <- if(all) rep(T, nrow(frame)) else frame$var == "<leaf>"
        if(method=='class') { 
            if (label=='yval') stat <- ylevels[frame$yval[leaves]]
	    else  if(!is.na(lev <- match(label, ylevels)))
		stat <- format(signif(frame$yprob[leaves, lev],
				      digits = digits))
            else stat <- frame$yval[leaves]
            if(use.n) 
		  stat <- paste(stat,'\n','(',
			   apply(frame$yval2[leaves,], 1, paste, collapse='/'),
      			     ')', sep='') 
	      }
	else if(method=='anova') {
	    stat <- format(signif(frame[leaves, label], digits =digits))
            if(use.n) stat <-
	       paste(stat,'\n',' n=',frame$n[leaves], sep='')
	   }
	else if(method=='poisson'|method=='exp')
	  {
	   stat <- format(signif(frame[leaves, label], digits = digits))
	   if(use.n)
             { stat <-
	     paste(stat,'\n', frame$yval2[leaves],'/',frame$n[leaves], sep="")
	       }	    
     
	 }

        oval <- function(middlex,middley,a,b) {

             theta <- seq(0,2*pi,pi/30)
	     newx <- middlex + a*cos(theta)
	     newy <- middley + b*sin(theta)

	     polygon(newx,newy,border=T,col=0)
#	     polygon(newx,newy,border=T)
	   }
  
        rectangle <- function(middlex, middley,a,b) {

	  newx <- middlex + c(a,a,-a,-a)
	  newy <- middley + c(b,-b,-b,b)

	  polygon(newx,newy,border=T,col=0)
#	  polygon(newx,newy,border=T)
          }

        if(fancy) {

	        ## find maximum length of stat
	        maxlen <- max(string.bounding.box(stat)$columns) + 1
	        maxht <- max(string.bounding.box(stat)$rows) +1

		if(fwidth<1)  a.length <- fwidth*cxy[1]*maxlen
		else a.length <- fwidth*cxy[1]

		if(fheight<1) b.length <- fheight*cxy[2]*maxht
		else b.length <- fheight*cxy[2]
		
	        ### create ovals and rectangles here
		## sqrt(2) creates the smallest oval that fits around the
		## best fitting rectangle
		for(i in parent) oval(xy$x[i],xy$y[i],
  			          a=sqrt(2)*a.length/2, b=sqrt(2)*b.length/2)
		child <- match(node[frame$var=="<leaf>"],node)
		for(i in child) rectangle(xy$x[i],xy$y[i],
				  a=a.length/2,b=b.length/2)
	      }

#if FUN=text then adj=1 puts the split label to the left of the 
#    split rather than centered
#Allow labels at all or just leaf nodes

	## stick values on nodes
	if(fancy) FUN(xy$x[leaves], xy$y[leaves] + .5 * cxy[2], stat, ...)
	else FUN(xy$x[leaves], xy$y[leaves] - 0.5 * cxy[2], stat, adj=.5, ...)

	invisible()
}



