% Generated by roxygen2 (4.0.2): do not edit by hand
\name{EAPscores}
\alias{EAPscores}
\title{Compute EAP scores}
\usage{
EAPscores(grp, ..., naAction = NULL, compressed = FALSE)
}
\arguments{
\item{grp}{a list with spec, param, data, and minItemsPerScore}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{naAction}{deprecated, will be removed in the next release}

\item{compressed}{output one score per observed data row even when weightColumn is set (default FALSE)}
}
\description{
If you have missing data then you must specify
\code{minItemsPerScore}.  This option will set scores to NA when
there are too few items to make an accurate score estimate.  If
you are using the scores as point estimates without considering
the standard error then you should set \code{minItemsPerScore} as
high as you can tolerate. This will increase the amount of missing
data but scores will be more accurate. If you are carefully
considering the standard errors of the scores then you can set
\code{minItemsPerScore} to 1. This will mimic the behavior of most
other IFA software wherein scores are estimated if there is at
least 1 non-NA item for the score. However, it may make more sense
to set \code{minItemsPerScore} to 0. When set to 0, all NA rows
are scored to the prior distribution.
}
\examples{
spec <- list()
spec[1:3] <- rpf.grm(outcomes=3)
param <- sapply(spec, rpf.rparam)
data <- rpf.sample(5, spec, param)
colnames(param) <- colnames(data)
grp <- list(spec=spec, param=param, data=data, minItemsPerScore=1L)
EAPscores(grp)
}

