% Generated by roxygen2 (4.0.1): do not edit by hand
\name{copy_from}
\alias{copy_from}
\alias{copy_to}
\title{Bulk read and write}
\usage{
copy_from(what, psql_opts = "")

copy_to(x, tablename, schemaname = NULL, append = FALSE, psql_opts = "")
}
\arguments{
\item{what}{a table name or sql query string}

\item{psql_opts}{passed directly to the psql command line}

\item{x}{a data frame}

\item{tablename}{name of table to create}

\item{schemaname}{create table in this schema}

\item{append}{if false, drop and receate table}
}
\description{
Read from and write to a database using COPY
}
\details{
These functions use the SQL COPY command and therefore are much
faster than \code{\link{write_table}} and possibly
\code{\link{read_table}}. These functions also call PostgreSQL's
psql command from the command line and will fail if it is not
found on the search path.

Because these functions shell out to psql you do not need an
active connection. By specifying \code{psql_opts} you can connect
to any database without affecting the active connection. If you
do not specify \code{psql_opts} an attempt will be made to use
the active connection information. If that fails,
psql will use default connection settings.
}
\note{
These functions call \code{\link{read.csv}} and
\code{\link{write.csv}} and so will suffer the same bandwidth
limitations as those functions. I argue that is good enough.
There is little point in reading and writing datasets too large
for those functions in R. Better to bulk load using psql on
the command line and then use \code{\link{cursor}} to read the
data in small bits.
}
\examples{
\dontrun{
# example requires hflights
if ( ! require(hflights, quietly = TRUE) )
 stop("This example requires the \\'hflights\\' package")

# big dataset
data(hflights)
dim(hflights)

system(paste("createdb rpgtesting"))

opts = paste("-d rpgtesting")
system.time(copy_to(hflights, psql_opts = opts))
system.time(invisible(copy_from("hflights", psql_opts = opts)))

connect("rpgtesting")
begin()

## Sloooowwwwwww
## system.time(write_table(hflights))
system.time(invisible(read_table("hflights")))

rollback()
disconnect()
system(paste("dropdb rpgtesting"))}
}
\author{
Timothy H. Keitt
}

