% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/treeModel.R
\name{plot.rate.matrix}
\alias{plot.rate.matrix}
\title{Make a bubble plot of a transition matrix}
\usage{
\method{plot}{rate.matrix}(x, eq.freq = NULL, max.cex = 10,
  eq.freq.max.cex = 5, alphabet = NULL, col = NULL, eq.freq.col = NULL,
  filled = TRUE, add = FALSE, ...)
}
\arguments{
\item{x}{A square matrix representing a continuous-time markov model;
rows should sum to zero, with negative values cross the diagonal}

\item{eq.freq}{A numeric vector giving the equilibrium frequencies
of each state.  If provided, the equilibrium frequencies will be
plotted along the bottom.}

\item{max.cex}{A scaling factor which determines the size of the
largest circle}

\item{eq.freq.max.cex}{A scaling factor which determines the size
of the largest circle in the equilibrium frequencies.}

\item{alphabet}{A character vector representing the state names for
each row/column of the matrix.  Can either be a vector of size
\code{nrow(m)} or a single character string with \code{nrow(m)}
characters.  Can also be \code{NULL} for no row/column labels.}

\item{col}{If \code{NULL}, all circles will be drawn in black.
Otherwise, col can be a matrix of the same dimension of \code{m},
each entry should indicate the color used for the corresponding
cell in the transition matrix.}

\item{eq.freq.col}{(Only applicable when eq.freq provided).  Should
be vector of same length as eq.freq, though values will be recycled.
Values in the vector indicate colors to draw the equilibrium frequency
bubbles.}

\item{filled}{If \code{TRUE}, plot filled circles.}

\item{add}{If \code{TRUE}, add to the existing plot.  Otherwise create
a new plot.}

\item{...}{Further arguments to be passed to \code{plot}.}
}
\description{
Make a bubble plot of a transition matrix
}
\author{
Melissa J. Hubisz
}

