% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/treeModel.R
\name{setup.branch.site.tm}
\alias{setup.branch.site.tm}
\title{Set up a tree model for branch site selection analysis}
\usage{
setup.branch.site.tm(mod, foreground, bgc = FALSE, altModel = TRUE,
  init.sel.neg = 0, init.sel.pos = 0, init.bgc = 0, init.weights = NULL)
}
\arguments{
\item{mod}{an object of type \code{tm}}

\item{foreground}{a character string giving a tree branch name or label
identifying foreground branches}

\item{bgc}{If \code{TRUE}, then use 8 categories of sites; four with bgc
in the foreground and four without.}

\item{altModel}{If \code{TRUE}, then optimize the foreground positive
selection parameter (constrained > 0).  Otherwise hold constant at 0.}

\item{init.sel.neg}{Initial value for negative selection parameter}

\item{init.sel.pos}{Initial value for positive selection paramter}

\item{init.bgc}{Initial value for bgc parameter (Ignored if bgc==FALSE)}

\item{init.weights}{Numeric vector of length three giving the initial
weight parameters.  The first two values determine the relative
frequencies of negatively, neutral, and positively selected sites.  The
last parameter determines the frequency of sites affected by bgc, and is
ignored if bgc==FALSE. All values should be >= 0.}
}
\value{
An object of type \code{tm} which can be used as the init.mod
argument to phyloFit to perform the branch-site test.
}
\description{
Set up a tree model for branch site selection analysis
}
\author{
Melissa J. Hubisz
}

