% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name_sets.R
\name{nameset}
\alias{nameset}
\alias{nameset_get}
\alias{nameset_taxonomy}
\title{Perform actions with name sets}
\usage{
nameset_get(uuid, options = NULL, ...)

nameset_taxonomy(uuid, options = NULL, ...)
}
\arguments{
\item{uuid}{the UUID of a set of taxonomic names}

\item{options}{(character) One or more of citationStart, html,
namebankID, root, string, type, uid, uri, and/or votes}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
a named list
}
\description{
Perform actions with name sets
}
\details{
\code{nameset_get()} retrieves information on a set of taxonomic
names. \code{nameset_taxonomy()} collects taxonomic data for a set of
taxonomic names.
}
\section{\code{options} parameter}{

Same as those for \verb{name_*()} functions
}

\examples{
\dontrun{
# Retrieves information on a set of taxonomic names.
id <- "8d9a9ea3-95cc-414d-1000-4b683ce04be2"
nameset_get(uuid = id)
nameset_get(uuid = id, options=c('names','string'))

# Collects taxonomic data for a name.
nameset_taxonomy(uuid = "8d9a9ea3-95cc-414d-1000-4b683ce04be2",
  options = "string")
nameset_taxonomy(uuid = "8d9a9ea3-95cc-414d-1000-4b683ce04be2",
  supertaxa="immediate", options=c("string","namebankID"))
}
}
