% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpicosat.R
\name{picosat_sat}
\alias{picosat_sat}
\title{Solve SAT problems with the 'PicoSAT' solver}
\usage{
picosat_sat(formula, assumptions = integer(0L))
}
\arguments{
\item{formula}{a list of integer vectors. Each vector is a clause.
Each integer identifies a literal. No element must be 0.
Negative integers are negated literals.}

\item{assumptions}{an optional integer vector. Assumptions are fixed values for literals in your formula.
Each element corresponds to a literal.
Negative literals are FALSE, positive TRUE.}
}
\value{
a data.frame with two columns, variable and value. In case the solution status
  is not PICOSAT_SATISFIABLE the resulting data.frame has 0 rows.
  You can use `picosat_solution_status` to decide if the problem is satisfiable.
}
\description{
The solver takes a formula in conjunctive normal form and finds
a satisfiable assignment of the
literals or returns that the formula is not satisfiable.
}
\examples{
# solve a boolean formula
# (not a or b) and (not b or c)
# each variable is an integer
# negations are negative integers
formula <- list(
 c(-1L, 2L),
 c(-2L, 3L)
)
res <- picosat_sat(formula)
picosat_solution_status(res)

# set a variable to a fixed value
# e.g. a = TRUE and b = TRUE
res <- picosat_sat(formula, assumptions = c(1L, 2L))
picosat_solution_status(res)

# get further information about the solution process
picosat_variables(res)
picosat_added_original_clauses(res)
picosat_decisions(res)
picosat_propagations(res)
picosat_visits (res)
picosat_seconds(res)

}
\references{
PicoSAT version 965 by Armin Biere: \url{http://fmv.jku.at/picosat/}

A. Biere. PicoSAT Essentials. Journal on Satisfiability, Boolean Modeling and Computation, 4:75–97, 2008.
}
