% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rpnf-package.R
\docType{package}
\name{rpnf-package}
\alias{rpnf-package}
\title{rpnf - The R Point & Figure Package}
\description{
rpnf is a tool set to create and analyze Point & Figure Charts for given time series or data frame objects.
}
\examples{
# Load rpnf library
library(rpnf)
# Load free available sample data
data(DOW)
# Determine point and figure informations for a linear chart with boxsize of 1 point
pnfdata <- pnfprocessor(
  high=DOW$High,
  low=DOW$Low,
  date=DOW$Date,
  boxsize=1L,
  log=FALSE)
# Show the object obtained
str(pnfdata)
# Show the data obtained
pnfdata
# Create a TXT based plot with X and O's
pnfplottxt(pnfdata,boxsize=1L,log=FALSE)
# Create a more graphical plot
pnfplot(pnfdata)
\dontrun{
### Second example: logarithmc example
# For most stocks and indices it is useful
# to do the analysis on a logarithmic scale.
# This can be done with pnfprocessor, too.
# Ensure to make use of the getLogBoxsize() function
# for an appropriate boxsize of a logarithmic chart.
# Determine point and figure informations for a logarithmic chart with boxsize 2\\\%
symbol.pnf <- pnfprocessor(
  high=DOW$High,
  low=DOW$Low,
  date=DOW$Date,
  boxsize=getLogBoxsize(2),
  log=TRUE)

# View the result
tail(symbol.pnf)
#View(symbol.pnf)

# or plot it as a modern chart
pnfplot(symbol.pnf,main="P&F Plot DOW (log)")
# Or in the old traditional TXT style
pnfplottxt(symbol.pnf,boxsize=getLogBoxsize(2),log=TRUE,main="P&F Plot DOW (log)")

### Additional examples
# Examples for additional uses cases like
# - relative strength vs index
# - bullish percent of an index
# - and many others
# can be found in your local package library directory.
# Search for rpnf-example1.R, rpnf-example2.R and so on.
}
}
\author{
Sascha Herrmann \email{sascha.herrmann.consulting@gmail.com}
}
\references{
Project Home Page \url{http://rpnf.r-forge.r-project.org}

Dorsey, Thomas J. Point and Figure Charting: The Essential Application for Forecasting and Tracking Market Prices. 3rd ed. Wiley Trading. Hoboken, N.J: John Wiley & Sons, 2007.

German version, which is the base for the package: Dorsey, Thomas. Sicher anlegen mit point & figure: klare Signale mit einfachen Methoden. Munich: FinanzBuch-Verl., 2000.
}
\seealso{
\code{\link{pnfprocessor}}

\code{\link{pnfplot}}

\code{\link{pnfplottxt}}
}
\keyword{package}

