% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbWriteDataFrame.R
\name{dbWriteDataFrame}
\alias{dbWriteDataFrame}
\alias{dbWriteDF}
\alias{dbReadDataFrame}
\alias{dbReadDF}
\title{Write/read in data frame mode to/from database table.}
\usage{
dbWriteDataFrame(conn, name, df, overwrite = FALSE, only.defs = FALSE)

dbReadDataFrame(conn, name, df = NULL)
}
\arguments{
\item{conn}{A connection object to a PostgreSQL database}

\item{name}{Character, schema and table of the PostgreSQL table}

\item{df}{The data frame to write (for \code{dbReadDataFrame}, this
allows to update an existing \code{data.frame} with definitions
stored in the database)}

\item{overwrite}{Logical; if TRUE, a new table (\code{name}) will
overwrite the existing table (\code{name}) in the database. Note:
overwriting a view must be done manually (e.g., with \code{\link[rpostgis]{dbDrop}}).}

\item{only.defs}{Logical; if \code{TRUE}, only the table
definitions will be written.}
}
\value{
\code{TRUE} for successful write with
    \code{dbWriteDataFrame}, \code{data.frame} for
    \code{dbReadDataFrame}
}
\description{
Write \code{data.frame} to database table, with column definitions,
row names, and a new integer primary key column. Read back into R
with \code{dbReadDataFrame}, which recreates original data frame.
}
\details{
Writing in data frame mode is only for new database tables (or for
overwriting an existing one). It will save all column names as they
appear in R, along with column data types and attributes.  This is
done by adding metadata to a lookup table in the table's schema
named ".R_df_defs" (will be created if not present).  It also adds
two fields with fixed names to the database table: ".R_rownames"
(storing the row.names of the data frame), and ".db_pkid", which is
a new integer primary key. Existing columns in the data.frame
matching these names will be automatically changed.

The \code{rpostgis} database table read functions
\code{dbReadDataFrame} and \code{pgGetGeom} will use the metadata
created in data frame mode to recreate a data.frame in R, if it is
available. Otherwise, it will be imported using default
\code{RPostgreSQL::dbReadTable} methods.

All \code{Spatial*DataFrame}s must be written with \code{\link[rpostgis]{pgInsert}}.
For more flexible writing of \code{data.frame}s to the database
(including all writing into existing database tables), use
\code{\link[rpostgis]{pgInsert}} with \code{df.mode = FALSE}.
}
\examples{
\dontrun{
library(sp)
data(meuse)

## Write the data.frame to the database:
dbWriteDataFrame(conn, name = "meuse_data", df = meuse)

## Reads it back into a different object:
me2 <- dbReadDataFrame(conn, name = "meuse_data")

## Check equality:
all.equal(meuse, me2)
## Should return TRUE.
}
}
\author{
David Bucklin \email{dbucklin@ufl.edu}
}
