% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asPgtraj.R
\name{asPgtraj}
\alias{asPgtraj}
\title{Imports location data from a database table into the pgtraj database model}
\usage{
asPgtraj(conn, relocations_table, schema = "traj", pgtrajs = "pgtraj",
  animals = "animal", bursts = NULL, relocations, timestamps = NULL,
  rids = "rid", srid = NULL, tzone = NULL, note = NULL,
  clauses = NULL, info_cols = NULL, info_table = NULL, info_rids = NULL)
}
\arguments{
\item{conn}{Connection object created with RPostgreSQL}

\item{relocations_table}{String. Name of the schema and table that stores 
the relocations, e.g. c("schema","relocations")}

\item{schema}{String. Name of the schema that stores or will store the 
pgtraj data model (Default = "traj").}

\item{pgtrajs}{String. Name of the pgtraj or name of the field that 
stores the pgtraj names.}

\item{animals}{String. Name of the animal or name of the field that 
stores the animal names.}

\item{bursts}{String. (Optional) name of the burst or name of the field
that stores the burst names. If not given, each animal will have one 
burst.}

\item{relocations}{String. Name of the field that contains the relocations 
in relocations_table. Relocations can be provided either as columns names
containing X,Y coordinates (e.g., \code{c("x","y")}) or a PostGIS geometry
(e.g., \code{"geom"}). In both cases all relocations in relocations_table 
must have the same projection. If provided as coordinates in two columns,
projection will be undefined unless \code{srid} is defined.}

\item{timestamps}{String. Name of the field in relocations_table that 
contains the timestamps. If NULL, Type I trajectory is assumed.}

\item{rids}{String. Name of the field in relocations_table that contains 
the numeric IDs of relocations. If \code{timestamps = NULL}, relocations 
will be sorted by the ascending numeric IDs in this field.}

\item{srid}{Integer. Optional SRID (spatial reference ID) of (x,y)
coordinates provided for relocations. Ignored if relocations is a 
geometry type.}

\item{tzone}{String. Time zone specification for the timestamps column. If not
specified, the database server time zone will be used (usually the server's local
time zone).}

\item{note}{String. Comment on the pgtraj. The comment is only used in
the database and not transferred into the ltraj.}

\item{clauses}{character, additional SQL to append to modify data 
selected from relocations_table. Must begin with \code{WHERE ...}, 
and cannot contain \code{ORDER BY} or \code{LIMIT} clauses.}

\item{info_cols}{String. Optional character vector of database table 
column names storing additional information on relocations 
(replicating "infolocs" from the \code{adehabitatLT} object \code{ltraj}).}

\item{info_table}{Character vector of \code{c("schema","table")} holding the 
\code{info_cols}. If \code{info_cols} are in \code{relocations_table}, 
leave NULL.}

\item{info_rids}{String. Column name of unique integer ID in \code{info_table} 
to join with \code{rids} from \code{relocations_table}. If \code{info_cols} 
are in \code{relocations_table}, leave NULL.}
}
\value{
TRUE on success
}
\description{
\code{asPgtraj} populates a \code{pgtraj} schema from the data provided
in \code{relocations_table}. If the provided schema doesn't exist, it will 
be created. On successful data input, \code{asPgtraj} creates two database 
views for each new pgtraj. These views are named parameters_<pgtraj_name>, 
step_geometry_<pgtraj_name> and described in more detail in the package 
vignette.
}
\details{
Opening and closing PostgreSQL connections have to be done manually by the user. 
However, the function checks if the provided connection is still valid.

Note that the arguments \code{pgtrajs}, \code{animals}, \code{bursts}, and 
\code{note} can refer to either a column name in \code{relocations_table},
or a string value. If the value is a column name, the values for the corresponding
attribute (e.g., \code{animals}) will be the values from that column.
When providing a string value, the value will be applied to that attribute for 
the entire \code{pgtraj}.

Burst names must be unique across a pgtraj. If it is not desired to further 
subset individual animal trajectories, leave \code{bursts = NULL},
in which case burst names will be equal to the animal name.

The time zone of the pgtraj is set to the local time zone of the user.
}
\examples{
\dontrun{
asPgtraj(conn, 
        relocations_table = c("example_data","relocations_plus"),
        pgtrajs = "id",
        animals = "animal",
        bursts = "burst",
        relocations = "geom",
        timestamps = "time",
        rids = "gid",
        note = "trajectories in 2015",
        clauses = "WHERE extract(year FROM acquisition_time) = 2015",
        info_cols = c("dist_to_road","land_cover","error_class")
        )
}

\dontrun{
asPgtraj(conn, 
        relocations_table = c("example_data","relocations_plus"),
        schema = "traj_t4",
        pgtrajs = "id",
        animals = "animal",
        bursts = "burst",
        relocations = c("x","y"),
        timestamps = "time",
        rids = "gid")
}
}
\references{
\url{https://CRAN.R-project.org/package=adehabitatLT/vignettes/adehabitatLT.pdf}
}
\seealso{
Section on pgtraj data model in the package vignette.
}
\author{
Balázs Dukai \email{balazs.dukai@gmail.com}

David Bucklin \email{dbucklin@ufl.edu}
}
