% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_eqn.R
\name{est_eqn}
\alias{est_eqn}
\title{Estimating Equations for \code{rpsftm()}}
\usage{
est_eqn(psi, data, formula, target = 0, test = "survdiff", autoswitch, ...)
}
\arguments{
\item{psi}{the parameter that measures how more rapidly the lifetime is expended under treatment}

\item{data}{the data set that contains the variables. 
Must contain columns named: time, censor_time,rx, arm.
Optionally a column named: treat_modifier}

\item{formula}{a forumula object of covariates to adjust for: \code{~strata(A)+B*C}}

\item{target}{the value to subtract off from the z-statistic}

\item{test}{the survival regression function to calculate the z-statistic: survdiff, coxph, survreg}

\item{autoswitch}{a logical to autodetect cases of no switching. Default is TRUE. If all observations in an arm
have perfect compliance then recensoring is not applied in that arm. If FALSE the recensoring is applied
regardless of perfect compliance.}

\item{...}{arguments to supply to the test function.}
}
\value{
A scalar value of the estimating equation: the z-statistics from a test minus a target value
}
\description{
Calculates the Estimating Equation to be solved in RPSFTM models
}
\author{
Simon Bond
}
\seealso{
\code{\link{untreated}}
}

