% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/untreated.R
\name{untreated}
\alias{untreated}
\title{Untreated Event Time}
\usage{
untreated(psi, time, delta, censor_time, rx, arm, autoswitch)
}
\arguments{
\item{psi}{the parameter that measures how more rapidly the lifetime is expended under treatment}

\item{time}{the observed failure or censoring time.}

\item{delta}{the status of the time: 1 = observed, 0 = censored.}

\item{censor_time}{the theoretical censoring time, either observed or set after time. Set to Inf to ignore recensoring.}

\item{rx}{the proportion of time spent on treatment}

\item{arm}{the randomised arm. Either a numerical indicator, with 0 as the placebo, or a factor with the lowest level as placebo.}

\item{autoswitch}{a logical to autodetect cases of no switching. Default is TRUE. If all observations in an arm
have perfect compliance then recensoring is not applied in that arm. If FALSE the recensoring is applied
regardless of perfect compliance.}
}
\value{
A Surv() object
}
\description{
Calculates the counterfactual untreated event time, possibly using the recensoring method, assuming a given parameter value and returns a Surv() object
}
\author{
Simon Bond
}

