% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{ants_resample_image}
\alias{ants_resample_image}
\title{Resample image}
\usage{
ants_resample_image(
  x,
  resample_params,
  use_voxels = FALSE,
  interp_type = c("linear", "nn", "guassian", "sinc", "bspline")
)
}
\arguments{
\item{x}{input image}

\item{resample_params}{either relative number or absolute integers}

\item{use_voxels}{whether the \code{resample_params} should be treated as
new dimension \code{use_voxels=TRUE}, or the new dimension should be
calculated based on current dimension and \code{resample_params} combined
(\code{use_voxels=FALSE} then \code{resample_params} will be treated as
relative number); default is \code{FALSE}}

\item{interp_type}{interpolation type; either integer or character; see
'Usage' for available options}
}
\value{
Resampled image
}
\description{
See \code{ants$resample_image} for more details
}
\examples{


if(interactive() && ants_available()) {
  ants <- load_ants()
  fi <- as_ANTsImage(ants$get_ants_data("r16"))

  # linear (interp_type = 0 or "linear)
  filin <- ants_resample_image(fi, c(50, 60), TRUE, "linear")

  # nearest neighbor (interp_type = 1 or "nn)
  finn <- ants_resample_image(fi, c(50, 60), TRUE, "nn")

  par(mfrow = c(1, 3), mar = c(0, 0, 0, 0))
  pal <- gray.colors(256, start = 0)

  image(fi[], asp = 1, axes = FALSE,
        ylim = c(1,0), col = pal)
  image(filin[], asp = 1, axes = FALSE,
        ylim = c(1,0), col = pal)
  image(finn[], asp = 1, axes = FALSE,
        ylim = c(1,0), col = pal)
}


}
