% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_opal.R
\name{get_course_elements}
\alias{get_course_elements}
\title{Get elements of the course by courseId}
\usage{
get_course_elements(
  course_id,
  api_user = NULL,
  api_password = NULL,
  endpoint = NULL
)
}
\arguments{
\item{course_id}{A length one character vector with course id.}

\item{api_user}{A character value of the username in the OPAL.}

\item{api_password}{A character value of the password in the OPAL.}

\item{endpoint}{A string of endpoint of LMS Opal; by default it is got from
environment variable \code{RQTI_API_ENDPOINT}. To set a global environment
variable, you need to call \code{Sys.setenv(RQTI_API_ENDPOINT='xxxxxxxxxxxxxxx')}
or you can put these command into .Renviron.}
}
\value{
A dataframe with the elements of the course (fields: nodeId,
shortTitle, shortName, longTitle)
}
\description{
Get elements of the course by courseId
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
df <- get_course_elements("89068111333293")
\dontshow{\}) # examplesIf}
}
