/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.Stack;

public class AlgebraQuad
extends TransformCopy {
    private AlgebraQuad() {
    }

    public static Op quadize(Op op) {
        Stack<Node> stack = new Stack<Node>();
        stack.push(Quad.defaultGraphNodeGenerated);
        Pusher before = new Pusher(stack);
        Popper after = new Popper(stack);
        TransformQuadGraph qg = new TransformQuadGraph(stack);
        return Transformer.transformSkipService(qg, op, before, after);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformQuadGraph
    extends TransformCopy {
        private Stack<Node> tracker;

        public TransformQuadGraph(Stack<Node> tracker) {
            this.tracker = tracker;
        }

        private Node getNode() {
            return this.tracker.peek();
        }

        @Override
        public Op transform(OpGraph opGraph, Op op) {
            boolean noPattern = false;
            if (OpBGP.isBGP(op)) {
                if (((OpBGP)op).getPattern().isEmpty()) {
                    noPattern = true;
                }
            } else if (op instanceof OpTable && ((OpTable)op).isJoinIdentity()) {
                noPattern = true;
            }
            if (noPattern) {
                return new OpDatasetNames(opGraph.getNode());
            }
            return op;
        }

        @Override
        public Op transform(OpPath opPath) {
            return new OpGraph(this.getNode(), opPath);
        }

        @Override
        public Op transform(OpBGP opBGP) {
            return new OpQuadPattern(this.getNode(), opBGP.getPattern());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Popper
    extends OpVisitorBase {
        Stack<Node> stack;

        Popper(Stack<Node> stack) {
            this.stack = stack;
        }

        @Override
        public void visit(OpGraph opGraph) {
            Node n = this.stack.pop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pusher
    extends OpVisitorBase {
        Stack<Node> stack;

        Pusher(Stack<Node> stack) {
            this.stack = stack;
        }

        @Override
        public void visit(OpGraph opGraph) {
            this.stack.push(opGraph.getNode());
        }
    }
}

