/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.binding;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingBase;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import java.util.Iterator;

public class BindingUtils {
    public static Binding asBinding(QuerySolution qSolution) {
        if (qSolution == null) {
            return null;
        }
        BindingMap binding = new BindingMap(null);
        BindingUtils.addToBinding(binding, qSolution);
        return binding;
    }

    public static void addToBinding(Binding binding, QuerySolution qSolution) {
        if (qSolution == null) {
            return;
        }
        Iterator<String> iter = qSolution.varNames();
        while (iter.hasNext()) {
            String n = iter.next();
            RDFNode x = qSolution.get(n);
            if (Var.isBlankNodeVarName(n)) continue;
            try {
                binding.add(Var.alloc(n), x.asNode());
            }
            catch (Exception ex) {
                System.err.println("!!!");
            }
        }
    }

    public static boolean equals(Binding b1, Binding b2) {
        return BindingBase.equals(b1, b2);
    }
}

