/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang.rdql;

import com.hp.hpl.jena.sparql.lang.rdql.RDQL_Node;
import java.util.Stack;

class JJTRDQLParserState {
    private Stack<RDQL_Node> nodes = new Stack();
    private Stack<Integer> marks = new Stack();
    private int sp = 0;
    private int mk = 0;
    private boolean node_created;

    JJTRDQLParserState() {
    }

    boolean nodeCreated() {
        return this.node_created;
    }

    void reset() {
        this.nodes.removeAllElements();
        this.marks.removeAllElements();
        this.sp = 0;
        this.mk = 0;
    }

    RDQL_Node rootNode() {
        return (RDQL_Node)this.nodes.elementAt(0);
    }

    void pushNode(RDQL_Node n) {
        this.nodes.push(n);
        ++this.sp;
    }

    RDQL_Node popNode() {
        if (--this.sp < this.mk) {
            this.mk = this.marks.pop();
        }
        return this.nodes.pop();
    }

    RDQL_Node peekNode() {
        return this.nodes.peek();
    }

    int nodeArity() {
        return this.sp - this.mk;
    }

    void clearNodeScope(RDQL_Node n) {
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.mk = this.marks.pop();
    }

    void openNodeScope(RDQL_Node n) {
        this.marks.push(new Integer(this.mk));
        this.mk = this.sp;
        n.jjtOpen();
    }

    void closeNodeScope(RDQL_Node n, int num) {
        this.mk = this.marks.pop();
        while (num-- > 0) {
            RDQL_Node c = this.popNode();
            c.jjtSetParent(n);
            n.jjtAddChild(c, num);
        }
        n.jjtClose();
        this.pushNode(n);
        this.node_created = true;
    }

    void closeNodeScope(RDQL_Node n, boolean condition) {
        if (condition) {
            int a = this.nodeArity();
            this.mk = this.marks.pop();
            while (a-- > 0) {
                RDQL_Node c = this.popNode();
                c.jjtSetParent(n);
                n.jjtAddChild(c, a);
            }
            n.jjtClose();
            this.pushNode(n);
            this.node_created = true;
        } else {
            this.mk = this.marks.pop();
            this.node_created = false;
        }
    }
}

