/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.pfunction.library;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConcat;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArgType;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionEval;
import com.hp.hpl.jena.sparql.util.graph.GraphList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListBase
extends PropertyFunctionEval {
    private PropFuncArgType objFuncArgType;

    public ListBase(PropFuncArgType objFuncArgType) {
        super(PropFuncArgType.PF_ARG_SINGLE, objFuncArgType);
    }

    @Override
    public final QueryIterator execEvaluated(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        Node listNode = argSubject.getArg();
        if (!Var.isVar(listNode)) {
            return this.execOneList(binding, listNode, predicate, argObject, execCxt);
        }
        Var listVar = Var.alloc(listNode);
        return this.listUnboundSubject(binding, listVar, predicate, argObject, execCxt);
    }

    private QueryIterator listUnboundSubject(Binding binding, Var listVar, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        if (argObject.isList()) {
            List<Node> objectArgs = argObject.getArgList();
            return this.execObjectList(binding, listVar, predicate, objectArgs, execCxt);
        }
        Node obj = argObject.getArg();
        if (Var.isVar(obj)) {
            Graph graph = execCxt.getActiveGraph();
            Set<Node> x = GraphList.findAllLists(graph);
            return this.allLists(binding, x, listVar, obj, argObject, execCxt);
        }
        return this.execObjectBound(binding, listVar, predicate, obj, execCxt);
    }

    protected QueryIterator allLists(Binding binding, Collection<Node> x, Var listVar, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        QueryIterConcat qIter = new QueryIterConcat(execCxt);
        for (Node n : x) {
            Binding b = BindingFactory.binding(binding, listVar, n);
            QueryIterator q = this.execOneList(b, n, predicate, argObject, execCxt);
            qIter.add(q);
        }
        return qIter;
    }

    protected abstract QueryIterator execObjectBound(Binding var1, Var var2, Node var3, Node var4, ExecutionContext var5);

    protected abstract QueryIterator execObjectList(Binding var1, Var var2, Node var3, List<Node> var4, ExecutionContext var5);

    protected abstract QueryIterator execOneList(Binding var1, Node var2, Node var3, PropFuncArg var4, ExecutionContext var5);
}

