/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import java.util.List;
import org.openjena.atlas.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lib {
    private Lib() {
    }

    public static final <T> boolean equal(T obj1, T obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static final String className(Object obj) {
        return Lib.classShortName(obj.getClass());
    }

    public static final String classShortName(Class<?> cls) {
        String tmp = cls.getName();
        int i = tmp.lastIndexOf(46);
        tmp = tmp.substring(i + 1);
        return tmp;
    }

    public static <T> boolean equalsListAsSet(List<T> list1, List<T> list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null) {
            return false;
        }
        if (list2 == null) {
            return false;
        }
        return list1.containsAll(list2) && list2.containsAll(list1);
    }

    public static final int hashCodeObject(Object obj) {
        return Lib.hashCodeObject(obj, -4);
    }

    public static final int hashCodeObject(Object obj, int nullHashCode) {
        if (obj == null) {
            return nullHashCode;
        }
        return obj.hashCode();
    }

    public static final void sleep(int milliSeconds) {
        try {
            Thread.sleep(milliSeconds);
        }
        catch (InterruptedException ex) {
            Log.warn(Lib.class, "interrupted", (Throwable)ex);
        }
    }
}

