/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;

public abstract class LogMergePolicy
extends MergePolicy {
    public static final double LEVEL_LOG_SPAN = 0.75;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    private int mergeFactor = 10;
    long minMergeSize;
    long maxMergeSize;
    int maxMergeDocs = Integer.MAX_VALUE;
    private boolean useCompoundFile = true;
    private boolean useCompoundDocStore = true;
    private IndexWriter writer;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void message(String message) {
        if (this.writer != null) {
            this.writer.message("LMP: " + message);
        }
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setMergeFactor(int mergeFactor) {
        if (mergeFactor < 2) {
            throw new IllegalArgumentException("mergeFactor cannot be less than 2");
        }
        this.mergeFactor = mergeFactor;
    }

    public boolean useCompoundFile(SegmentInfos infos, SegmentInfo info) {
        return this.useCompoundFile;
    }

    public void setUseCompoundFile(boolean useCompoundFile) {
        this.useCompoundFile = useCompoundFile;
    }

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public boolean useCompoundDocStore(SegmentInfos infos) {
        return this.useCompoundDocStore;
    }

    public void setUseCompoundDocStore(boolean useCompoundDocStore) {
        this.useCompoundDocStore = useCompoundDocStore;
    }

    public boolean getUseCompoundDocStore() {
        return this.useCompoundDocStore;
    }

    public void close() {
    }

    protected abstract long size(SegmentInfo var1) throws IOException;

    private boolean isOptimized(SegmentInfos infos, IndexWriter writer, int maxNumSegments, Set segmentsToOptimize) throws IOException {
        int numSegments = infos.size();
        int numToOptimize = 0;
        SegmentInfo optimizeInfo = null;
        for (int i = 0; i < numSegments && numToOptimize <= maxNumSegments; ++i) {
            SegmentInfo info = infos.info(i);
            if (!segmentsToOptimize.contains(info)) continue;
            ++numToOptimize;
            optimizeInfo = info;
        }
        return numToOptimize <= maxNumSegments && (numToOptimize != 1 || this.isOptimized(writer, optimizeInfo));
    }

    private boolean isOptimized(IndexWriter writer, SegmentInfo info) throws IOException {
        return !info.hasDeletions() && !info.hasSeparateNorms() && info.dir == writer.getDirectory() && info.getUseCompoundFile() == this.useCompoundFile;
    }

    public MergePolicy.MergeSpecification findMergesForOptimize(SegmentInfos infos, IndexWriter writer, int maxNumSegments, Set segmentsToOptimize) throws IOException {
        MergePolicy.MergeSpecification spec;
        if (!$assertionsDisabled && maxNumSegments <= 0) {
            throw new AssertionError();
        }
        if (!this.isOptimized(infos, writer, maxNumSegments, segmentsToOptimize)) {
            int last = infos.size();
            while (last > 0) {
                SegmentInfo info;
                if (!segmentsToOptimize.contains(info = infos.info(--last))) continue;
                ++last;
                break;
            }
            if (last > 0) {
                spec = new MergePolicy.MergeSpecification();
                while (last - maxNumSegments + 1 >= this.mergeFactor) {
                    spec.add(new MergePolicy.OneMerge(infos.range(last - this.mergeFactor, last), this.useCompoundFile));
                    last -= this.mergeFactor;
                }
                if (0 == spec.merges.size()) {
                    if (maxNumSegments == 1) {
                        if (last > 1 || !this.isOptimized(writer, infos.info(0))) {
                            spec.add(new MergePolicy.OneMerge(infos.range(0, last), this.useCompoundFile));
                        }
                    } else if (last > maxNumSegments) {
                        int finalMergeSize = last - maxNumSegments + 1;
                        long bestSize = 0L;
                        int bestStart = 0;
                        for (int i = 0; i < last - finalMergeSize + 1; ++i) {
                            long sumSize = 0L;
                            for (int j = 0; j < finalMergeSize; ++j) {
                                sumSize += this.size(infos.info(j + i));
                            }
                            if (i != 0 && (sumSize >= 2L * this.size(infos.info(i - 1)) || sumSize >= bestSize)) continue;
                            bestStart = i;
                            bestSize = sumSize;
                        }
                        spec.add(new MergePolicy.OneMerge(infos.range(bestStart, bestStart + finalMergeSize), this.useCompoundFile));
                    }
                }
            } else {
                spec = null;
            }
        } else {
            spec = null;
        }
        return spec;
    }

    public MergePolicy.MergeSpecification findMerges(SegmentInfos infos, IndexWriter writer) throws IOException {
        int numSegments = infos.size();
        this.writer = writer;
        this.message("findMerges: " + numSegments + " segments");
        float[] levels = new float[numSegments];
        float norm = (float)Math.log(this.mergeFactor);
        Directory directory = writer.getDirectory();
        for (int i = 0; i < numSegments; ++i) {
            SegmentInfo info = infos.info(i);
            long size = this.size(info);
            if (info.docCount > this.maxMergeDocs && info.dir != directory) {
                throw new IllegalArgumentException("Segment is too large (" + info.docCount + " docs vs max docs " + this.maxMergeDocs + ")");
            }
            if (size >= this.maxMergeSize && info.dir != directory) {
                throw new IllegalArgumentException("Segment is too large (" + size + " vs max size " + this.maxMergeSize + ")");
            }
            if (size < 1L) {
                size = 1L;
            }
            levels[i] = (float)Math.log(size) / norm;
        }
        float levelFloor = this.minMergeSize <= 0L ? 0.0f : (float)(Math.log(this.minMergeSize) / (double)norm);
        MergePolicy.MergeSpecification spec = null;
        int start = 0;
        while (start < numSegments) {
            int upto;
            float levelBottom;
            float maxLevel = levels[start];
            for (int i = 1 + start; i < numSegments; ++i) {
                float level = levels[i];
                if (!(level > maxLevel)) continue;
                maxLevel = level;
            }
            if (maxLevel < levelFloor) {
                levelBottom = -1.0f;
            } else {
                levelBottom = (float)((double)maxLevel - 0.75);
                if (levelBottom < levelFloor && maxLevel >= levelFloor) {
                    levelBottom = levelFloor;
                }
            }
            for (upto = numSegments - 1; upto >= start && !(levels[upto] >= levelBottom); --upto) {
            }
            this.message("  level " + levelBottom + " to " + maxLevel + ": " + (1 + upto - start) + " segments");
            int end = start + this.mergeFactor;
            while (end <= 1 + upto) {
                boolean anyTooLarge = false;
                for (int i = start; i < end; ++i) {
                    SegmentInfo info = infos.info(i);
                    anyTooLarge |= this.size(info) >= this.maxMergeSize || info.docCount >= this.maxMergeDocs;
                }
                if (!anyTooLarge) {
                    if (spec == null) {
                        spec = new MergePolicy.MergeSpecification();
                    }
                    this.message("    " + start + " to " + end + ": add this merge");
                    spec.add(new MergePolicy.OneMerge(infos.range(start, end), this.useCompoundFile));
                } else {
                    this.message("    " + start + " to " + end + ": contains segment over maxMergeSize or maxMergeDocs; skipping");
                }
                start = end;
                end = start + this.mergeFactor;
            }
            start = 1 + upto;
        }
        return spec;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    static {
        $assertionsDisabled = !LogMergePolicy.class.desiredAssertionStatus();
    }
}

