/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphStatisticsHandler;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.AllCapabilities;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.GraphMatcher;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.graph.impl.SimpleTransactionHandler;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.ClosedException;
import com.hp.hpl.jena.shared.DeleteDeniedException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.Reifier2;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphBase2
implements GraphWithPerform {
    protected boolean closed = false;
    protected QueryHandler queryHandler;
    protected GraphStatisticsHandler statisticsHandler;
    protected GraphEventManager gem;
    protected BulkUpdateHandler bulkHandler;
    protected Capabilities capabilities = null;
    private PrefixMapping pm = null;
    protected Reifier reifier = null;

    protected void checkOpen() {
        if (this.closed) {
            throw new ClosedException("already closed", (Graph)this);
        }
    }

    public void close() {
        this.closed = true;
        if (this.reifier != null) {
            this.reifier.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean dependsOn(Graph other) {
        return this == other;
    }

    public abstract QueryHandler queryHandler();

    public GraphStatisticsHandler getStatisticsHandler() {
        if (this.statisticsHandler == null) {
            this.statisticsHandler = this.createStatisticsHandler();
        }
        return this.statisticsHandler;
    }

    protected GraphStatisticsHandler createStatisticsHandler() {
        return null;
    }

    public GraphEventManager getEventManager() {
        if (this.gem == null) {
            this.gem = new SimpleEventManager((Graph)this);
        }
        return this.gem;
    }

    public void notifyAdd(Triple t) {
        this.getEventManager().notifyAddTriple((Graph)this, t);
    }

    public void notifyDelete(Triple t) {
        this.getEventManager().notifyDeleteTriple((Graph)this, t);
    }

    public TransactionHandler getTransactionHandler() {
        return new SimpleTransactionHandler();
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new SimpleBulkUpdateHandler((GraphWithPerform)this);
        }
        return this.bulkHandler;
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new AllCapabilities();
        }
        return this.capabilities;
    }

    public PrefixMapping getPrefixMapping() {
        if (this.pm == null) {
            this.pm = this.createPrefixMapping();
        }
        return this.pm;
    }

    protected abstract PrefixMapping createPrefixMapping();

    public void add(Triple t) {
        this.checkOpen();
        this.performAdd(t);
        this.notifyAdd(t);
    }

    public void performAdd(Triple t) {
        throw new AddDeniedException("GraphBase::performAdd");
    }

    public final void delete(Triple t) {
        this.checkOpen();
        this.performDelete(t);
        this.notifyDelete(t);
    }

    public void performDelete(Triple t) {
        throw new DeleteDeniedException("GraphBase::delete");
    }

    public final ExtendedIterator<Triple> find(TripleMatch m) {
        this.checkOpen();
        return this.graphBaseFind(m);
    }

    protected abstract ExtendedIterator<Triple> graphBaseFind(TripleMatch var1);

    public ExtendedIterator<Triple> forTestingOnly_graphBaseFind(TripleMatch tm) {
        return this.graphBaseFind(tm);
    }

    public final ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        this.checkOpen();
        return this.graphBaseFind(s, p, o);
    }

    protected ExtendedIterator<Triple> graphBaseFind(Node s, Node p, Node o) {
        return this.find((TripleMatch)Triple.createMatch((Node)s, (Node)p, (Node)o));
    }

    public final boolean contains(Triple t) {
        this.checkOpen();
        return this.graphBaseContains(t);
    }

    protected boolean graphBaseContains(Triple t) {
        return this.containsByFind(t);
    }

    public final boolean contains(Node s, Node p, Node o) {
        this.checkOpen();
        return this.contains(Triple.create((Node)s, (Node)p, (Node)o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean containsByFind(Triple t) {
        ExtendedIterator<Triple> it = this.find((TripleMatch)t);
        try {
            boolean bl = it.hasNext();
            return bl;
        }
        finally {
            it.close();
        }
    }

    public Reifier getReifier() {
        if (this.reifier == null) {
            this.reifier = this.constructReifier();
        }
        return this.reifier;
    }

    protected Reifier constructReifier() {
        return new Reifier2((Graph)this);
    }

    public final int size() {
        this.checkOpen();
        return this.graphBaseSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int graphBaseSize() {
        ExtendedIterator it = GraphUtil.findAll((Graph)this);
        try {
            int tripleCount = 0;
            while (it.hasNext()) {
                it.next();
                ++tripleCount;
            }
            int n = tripleCount;
            return n;
        }
        finally {
            it.close();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isIsomorphicWith(Graph g) {
        this.checkOpen();
        return g != null && GraphMatcher.equals((Graph)this, (Graph)g);
    }

    public String toString() {
        return GraphBase.toString((String)"", (Graph)this);
    }
}

