/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.syntax;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.syntax.TemplateVisitor;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateTriple
extends Template {
    Triple triple;

    public TemplateTriple(Node s, Node p, Node o) {
        this.triple = new Triple(s, p, o);
    }

    public TemplateTriple(Triple t) {
        this.triple = t;
    }

    public Triple getTriple() {
        return this.triple;
    }

    @Override
    public void subst(Collection<Triple> acc, Map<Node, Node> bNodeMap, Binding b) {
        Node s = this.triple.getSubject();
        Node p = this.triple.getPredicate();
        Node o = this.triple.getObject();
        if (s.isBlank()) {
            s = this.newBlank(s, bNodeMap);
        }
        if (p.isBlank()) {
            p = this.newBlank(p, bNodeMap);
        }
        if (o.isBlank()) {
            o = this.newBlank(o, bNodeMap);
        }
        Triple t = new Triple(s, p, o);
        Triple t2 = Substitute.substitute(t, b);
        acc.add(t2);
    }

    @Override
    public int hashCode() {
        if (this.triple == null) {
            return 2;
        }
        int hash = 0;
        hash = this.hashNode(this.triple.getSubject()) ^ hash << 1;
        hash = this.hashNode(this.triple.getPredicate()) ^ hash << 1;
        hash = this.hashNode(this.triple.getObject()) ^ hash << 1;
        return hash;
    }

    private int hashNode(Node node) {
        if (node.isBlank()) {
            return 57;
        }
        return node.hashCode();
    }

    @Override
    public boolean equalIso(Object temp2, NodeIsomorphismMap labelMap) {
        if (temp2 == null) {
            return false;
        }
        if (!(temp2 instanceof TemplateTriple)) {
            return false;
        }
        TemplateTriple tt2 = (TemplateTriple)temp2;
        if (labelMap == null) {
            return this.getTriple().equals((Object)tt2.getTriple());
        }
        return Utils.tripleIso(this.triple, this.getTriple(), labelMap);
    }

    @Override
    public void visit(TemplateVisitor visitor) {
        visitor.visit(this);
    }

    private static boolean nodeEquals(Node n1, Node n2, NodeIsomorphismMap isoMap) {
        if (n1.isBlank() && n2.isBlank()) {
            return isoMap.makeIsomorhpic(n1, n2);
        }
        return n1.equals((Object)n2);
    }

    private Node newBlank(Node n, Map<Node, Node> bNodeMap) {
        if (!bNodeMap.containsKey(n)) {
            bNodeMap.put(n, Node.createAnon());
        }
        return bNodeMap.get(n);
    }
}

